package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.component.ExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.InterfaceSignal;
import io.ciera.tool.sql.ooaofooa.component.InterfaceSignalSet;
import io.ciera.tool.sql.ooaofooa.component.impl.ExecutablePropertySetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceSignalSetImpl;
import io.ciera.tool.sql.ooaofooa.message.SignalMessageSet;
import io.ciera.tool.sql.ooaofooa.message.impl.SignalMessageSetImpl;

import java.util.Arrays;
import java.util.List;

import ooaofooa.datatypes.IFDirectionType;


public class InterfaceSignalSetImpl extends InstanceSet<InterfaceSignalSet,InterfaceSignal> implements InterfaceSignalSet {

    // attributes
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( InterfaceSignal interfacesignal : this ) interfacesignal.setName( m_Name );
    }
    @Override
    public void setPrevious_Id( UniqueId ref_Previous_Id ) throws XtumlException {
        for ( InterfaceSignal interfacesignal : this ) interfacesignal.setPrevious_Id( ref_Previous_Id );
    }
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        for ( InterfaceSignal interfacesignal : this ) interfacesignal.setId( ref_Id );
    }
    @Override
    public void setDirection( IFDirectionType m_Direction ) throws XtumlException {
        for ( InterfaceSignal interfacesignal : this ) interfacesignal.setDirection( m_Direction );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( InterfaceSignal interfacesignal : this ) interfacesignal.setDescrip( m_Descrip );
    }


    // selections
    @Override
    public SignalMessageSet R1021_sent_by_SignalMessage() throws XtumlException {
        SignalMessageSet signalmessageset = new SignalMessageSetImpl();
        for ( InterfaceSignal interfacesignal : this ) signalmessageset.addAll( interfacesignal.R1021_sent_by_SignalMessage() );
        return signalmessageset;
    }
    @Override
    public ExecutablePropertySet R4004_is_a_ExecutableProperty() throws XtumlException {
        ExecutablePropertySet executablepropertyset = new ExecutablePropertySetImpl();
        for ( InterfaceSignal interfacesignal : this ) executablepropertyset.add( interfacesignal.R4004_is_a_ExecutableProperty() );
        return executablepropertyset;
    }
    @Override
    public InterfaceSignalSet R4020_precedes_InterfaceSignal() throws XtumlException {
        InterfaceSignalSet interfacesignalset = new InterfaceSignalSetImpl();
        for ( InterfaceSignal interfacesignal : this ) interfacesignalset.add( interfacesignal.R4020_precedes_InterfaceSignal() );
        return interfacesignalset;
    }
    @Override
    public InterfaceSignalSet R4020_succeeds_InterfaceSignal() throws XtumlException {
        InterfaceSignalSet interfacesignalset = new InterfaceSignalSetImpl();
        for ( InterfaceSignal interfacesignal : this ) interfacesignalset.add( interfacesignal.R4020_succeeds_InterfaceSignal() );
        return interfacesignalset;
    }


    @Override
    public InterfaceSignal nullElement() {
        return InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }

    @Override
    public InterfaceSignalSet emptySet() {
      return new InterfaceSignalSetImpl();
    }

    @Override
    public InterfaceSignalSet value() {
        return this;
    }

    @Override
    public List<InterfaceSignal> elements() {
        InterfaceSignal[] elements = toArray(new InterfaceSignal[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
