package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.RequiredOperationBody;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredOperation;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredOperationImpl;


public class RequiredOperationBodyImpl extends ModelInstance<RequiredOperationBody,Sql> implements RequiredOperationBody {

    public static final String KEY_LETTERS = "ACT_ROB";
    public static final RequiredOperationBody EMPTY_REQUIREDOPERATIONBODY = new EmptyRequiredOperationBody();

    private Sql context;

    // constructors
    private RequiredOperationBodyImpl( Sql context ) {
        this.context = context;
        ref_Action_ID = UniqueId.random();
        ref_Id = UniqueId.random();
        R685_specifies_processing_for_RequiredOperation_inst = RequiredOperationImpl.EMPTY_REQUIREDOPERATION;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    private RequiredOperationBodyImpl( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Action_ID = ref_Action_ID;
        this.ref_Id = ref_Id;
        R685_specifies_processing_for_RequiredOperation_inst = RequiredOperationImpl.EMPTY_REQUIREDOPERATION;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    public static RequiredOperationBody create( Sql context ) throws XtumlException {
        RequiredOperationBody newRequiredOperationBody = new RequiredOperationBodyImpl( context );
        if ( context.addInstance( newRequiredOperationBody ) ) {
            newRequiredOperationBody.getRunContext().addChange(new InstanceCreatedDelta(newRequiredOperationBody, KEY_LETTERS));
            return newRequiredOperationBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RequiredOperationBody create( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Id ) throws XtumlException {
        RequiredOperationBody newRequiredOperationBody = new RequiredOperationBodyImpl( context, instanceId, ref_Action_ID, ref_Id );
        if ( context.addInstance( newRequiredOperationBody ) ) {
            return newRequiredOperationBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Action_ID;
    @Override
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Action_ID.inequality( this.ref_Action_ID ) ) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
                return ref_Action_ID;
    }
    private UniqueId ref_Id;
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private RequiredOperation R685_specifies_processing_for_RequiredOperation_inst;
    @Override
    public void setR685_specifies_processing_for_RequiredOperation( RequiredOperation inst ) {
        R685_specifies_processing_for_RequiredOperation_inst = inst;
    }
    @Override
    public RequiredOperation R685_specifies_processing_for_RequiredOperation() throws XtumlException {
        return R685_specifies_processing_for_RequiredOperation_inst;
    }
    private Body R698_is_a_Body_inst;
    @Override
    public void setR698_is_a_Body( Body inst ) {
        R698_is_a_Body_inst = inst;
    }
    @Override
    public Body R698_is_a_Body() throws XtumlException {
        return R698_is_a_Body_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RequiredOperationBody value() {
        return this;
    }

    @Override
    public RequiredOperationBody self() {
        return this;
    }

    @Override
    public RequiredOperationBody oneWhere( IWhere<RequiredOperationBody> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_REQUIREDOPERATIONBODY;
    }

}

class EmptyRequiredOperationBody extends ModelInstance<RequiredOperationBody,Sql> implements RequiredOperationBody {

    // attributes
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public RequiredOperation R685_specifies_processing_for_RequiredOperation() {
        return RequiredOperationImpl.EMPTY_REQUIREDOPERATION;
    }
    @Override
    public Body R698_is_a_Body() {
        return BodyImpl.EMPTY_BODY;
    }


    @Override
    public String getKeyLetters() {
        return RequiredOperationBodyImpl.KEY_LETTERS;
    }

    @Override
    public RequiredOperationBody value() {
        return this;
    }
    
    @Override
    public RequiredOperationBody self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RequiredOperationBody oneWhere( IWhere<RequiredOperationBody> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return RequiredOperationBodyImpl.EMPTY_REQUIREDOPERATIONBODY;
    }

}
