package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.FunctionBody;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.domain.S_SYNC;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_SYNCImpl;


public class FunctionBodyImpl extends ModelInstance<FunctionBody,Sql> implements FunctionBody {

    public static final String KEY_LETTERS = "ACT_FNB";
    public static final FunctionBody EMPTY_FUNCTIONBODY = new EmptyFunctionBody();

    private Sql context;

    // constructors
    private FunctionBodyImpl( Sql context ) {
        this.context = context;
        ref_Action_ID = UniqueId.random();
        ref_Sync_ID = UniqueId.random();
        R695_specifies_processing_for_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    private FunctionBodyImpl( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Sync_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Action_ID = ref_Action_ID;
        this.ref_Sync_ID = ref_Sync_ID;
        R695_specifies_processing_for_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    public static FunctionBody create( Sql context ) throws XtumlException {
        FunctionBody newFunctionBody = new FunctionBodyImpl( context );
        if ( context.addInstance( newFunctionBody ) ) {
            newFunctionBody.getRunContext().addChange(new InstanceCreatedDelta(newFunctionBody, KEY_LETTERS));
            return newFunctionBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FunctionBody create( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Sync_ID ) throws XtumlException {
        FunctionBody newFunctionBody = new FunctionBodyImpl( context, instanceId, ref_Action_ID, ref_Sync_ID );
        if ( context.addInstance( newFunctionBody ) ) {
            return newFunctionBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Action_ID;
    @Override
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Action_ID.inequality( this.ref_Action_ID ) ) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
                return ref_Action_ID;
    }
    private UniqueId ref_Sync_ID;
    @Override
    public void setSync_ID( UniqueId ref_Sync_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Sync_ID.inequality( this.ref_Sync_ID ) ) {
            final UniqueId oldValue = this.ref_Sync_ID;
            this.ref_Sync_ID = ref_Sync_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Sync_ID", oldValue, this.ref_Sync_ID));
        }
    }
    @Override
    public UniqueId getSync_ID() throws XtumlException {
        checkLiving();
                return ref_Sync_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private S_SYNC R695_specifies_processing_for_S_SYNC_inst;
    @Override
    public void setR695_specifies_processing_for_S_SYNC( S_SYNC inst ) {
        R695_specifies_processing_for_S_SYNC_inst = inst;
    }
    @Override
    public S_SYNC R695_specifies_processing_for_S_SYNC() throws XtumlException {
        return R695_specifies_processing_for_S_SYNC_inst;
    }
    private Body R698_is_a_Body_inst;
    @Override
    public void setR698_is_a_Body( Body inst ) {
        R698_is_a_Body_inst = inst;
    }
    @Override
    public Body R698_is_a_Body() throws XtumlException {
        return R698_is_a_Body_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FunctionBody value() {
        return this;
    }

    @Override
    public FunctionBody self() {
        return this;
    }

    @Override
    public FunctionBody oneWhere( IWhere<FunctionBody> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_FUNCTIONBODY;
    }

}

class EmptyFunctionBody extends ModelInstance<FunctionBody,Sql> implements FunctionBody {

    // attributes
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSync_ID( UniqueId ref_Sync_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSync_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public S_SYNC R695_specifies_processing_for_S_SYNC() {
        return S_SYNCImpl.EMPTY_S_SYNC;
    }
    @Override
    public Body R698_is_a_Body() {
        return BodyImpl.EMPTY_BODY;
    }


    @Override
    public String getKeyLetters() {
        return FunctionBodyImpl.KEY_LETTERS;
    }

    @Override
    public FunctionBody value() {
        return this;
    }
    
    @Override
    public FunctionBody self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FunctionBody oneWhere( IWhere<FunctionBody> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return FunctionBodyImpl.EMPTY_FUNCTIONBODY;
    }

}
