package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.Block;
import io.ciera.tool.sql.ooaofooa.body.ElseIfStmt;
import io.ciera.tool.sql.ooaofooa.body.IfStmt;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.BlockImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.IfStmtImpl;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class ElseIfStmtImpl extends ModelInstance<ElseIfStmt,Sql> implements ElseIfStmt {

    public static final String KEY_LETTERS = "ACT_EL";
    public static final ElseIfStmt EMPTY_ELSEIFSTMT = new EmptyElseIfStmt();

    private Sql context;

    // constructors
    private ElseIfStmtImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Block_ID = UniqueId.random();
        ref_Value_ID = UniqueId.random();
        ref_If_Statement_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R658_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R659_test_result_Value_inst = ValueImpl.EMPTY_VALUE;
        R682_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
        R690_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
    }

    private ElseIfStmtImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, UniqueId ref_Value_ID, UniqueId ref_If_Statement_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Block_ID = ref_Block_ID;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_If_Statement_ID = ref_If_Statement_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R658_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R659_test_result_Value_inst = ValueImpl.EMPTY_VALUE;
        R682_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
        R690_IfStmt_inst = IfStmtImpl.EMPTY_IFSTMT;
    }

    public static ElseIfStmt create( Sql context ) throws XtumlException {
        ElseIfStmt newElseIfStmt = new ElseIfStmtImpl( context );
        if ( context.addInstance( newElseIfStmt ) ) {
            newElseIfStmt.getRunContext().addChange(new InstanceCreatedDelta(newElseIfStmt, KEY_LETTERS));
            return newElseIfStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ElseIfStmt create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, UniqueId ref_Value_ID, UniqueId ref_If_Statement_ID ) throws XtumlException {
        ElseIfStmt newElseIfStmt = new ElseIfStmtImpl( context, instanceId, ref_Statement_ID, ref_Block_ID, ref_Value_ID, ref_If_Statement_ID );
        if ( context.addInstance( newElseIfStmt ) ) {
            return newElseIfStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
                return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Statement_ID.inequality( this.ref_Statement_ID ) ) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R690_IfStmt().isEmpty() ) R690_IfStmt().setElif_Statement_ID( ref_Statement_ID );
        }
    }
    private UniqueId ref_Block_ID;
    @Override
    public UniqueId getBlock_ID() throws XtumlException {
        checkLiving();
                return ref_Block_ID;
    }
    @Override
    public void setBlock_ID( UniqueId ref_Block_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Block_ID.inequality( this.ref_Block_ID ) ) {
            final UniqueId oldValue = this.ref_Block_ID;
            this.ref_Block_ID = ref_Block_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Block_ID", oldValue, this.ref_Block_ID));
        }
    }
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
                return ref_Value_ID;
    }
    @Override
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Value_ID.inequality( this.ref_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_If_Statement_ID;
    @Override
    public UniqueId getIf_Statement_ID() throws XtumlException {
        checkLiving();
                return ref_If_Statement_ID;
    }
    @Override
    public void setIf_Statement_ID( UniqueId ref_If_Statement_ID ) throws XtumlException {
        checkLiving();
        if ( ref_If_Statement_ID.inequality( this.ref_If_Statement_ID ) ) {
            final UniqueId oldValue = this.ref_If_Statement_ID;
            this.ref_If_Statement_ID = ref_If_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_If_Statement_ID", oldValue, this.ref_If_Statement_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Block R658_controls_Block_inst;
    @Override
    public void setR658_controls_Block( Block inst ) {
        R658_controls_Block_inst = inst;
    }
    @Override
    public Block R658_controls_Block() throws XtumlException {
        return R658_controls_Block_inst;
    }
    private Value R659_test_result_Value_inst;
    @Override
    public void setR659_test_result_Value( Value inst ) {
        R659_test_result_Value_inst = inst;
    }
    @Override
    public Value R659_test_result_Value() throws XtumlException {
        return R659_test_result_Value_inst;
    }
    private IfStmt R682_IfStmt_inst;
    @Override
    public void setR682_IfStmt( IfStmt inst ) {
        R682_IfStmt_inst = inst;
    }
    @Override
    public IfStmt R682_IfStmt() throws XtumlException {
        return R682_IfStmt_inst;
    }
    private IfStmt R690_IfStmt_inst;
    @Override
    public void setR690_IfStmt( IfStmt inst ) {
        R690_IfStmt_inst = inst;
    }
    @Override
    public IfStmt R690_IfStmt() throws XtumlException {
        return R690_IfStmt_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ElseIfStmt value() {
        return this;
    }

    @Override
    public ElseIfStmt self() {
        return this;
    }

    @Override
    public ElseIfStmt oneWhere( IWhere<ElseIfStmt> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ELSEIFSTMT;
    }

}

class EmptyElseIfStmt extends ModelInstance<ElseIfStmt,Sql> implements ElseIfStmt {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBlock_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_ID( UniqueId ref_Block_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getIf_Statement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIf_Statement_ID( UniqueId ref_If_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Block R658_controls_Block() {
        return BlockImpl.EMPTY_BLOCK;
    }
    @Override
    public Value R659_test_result_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public IfStmt R682_IfStmt() {
        return IfStmtImpl.EMPTY_IFSTMT;
    }
    @Override
    public IfStmt R690_IfStmt() {
        return IfStmtImpl.EMPTY_IFSTMT;
    }


    @Override
    public String getKeyLetters() {
        return ElseIfStmtImpl.KEY_LETTERS;
    }

    @Override
    public ElseIfStmt value() {
        return this;
    }
    
    @Override
    public ElseIfStmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ElseIfStmt oneWhere( IWhere<ElseIfStmt> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ElseIfStmtImpl.EMPTY_ELSEIFSTMT;
    }

}
