package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSubtype;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSubtypeSet;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSupertype;
import io.ciera.tool.sql.ooaofooa.association.SubtypeSupertypeAssociation;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsSubtypeSetImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsSupertypeImpl;


public class SubtypeSupertypeAssociationImpl extends ModelInstance<SubtypeSupertypeAssociation,Sql> implements SubtypeSupertypeAssociation {

    public static final String KEY_LETTERS = "R_SUBSUP";
    public static final SubtypeSupertypeAssociation EMPTY_SUBTYPESUPERTYPEASSOCIATION = new EmptySubtypeSupertypeAssociation();

    private Sql context;

    // constructors
    private SubtypeSupertypeAssociationImpl( Sql context ) {
        this.context = context;
        ref_Rel_ID = UniqueId.random();
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R212_relates_ClassAsSupertype_inst = ClassAsSupertypeImpl.EMPTY_CLASSASSUPERTYPE;
        R213_relates_ClassAsSubtype_set = new ClassAsSubtypeSetImpl();
    }

    private SubtypeSupertypeAssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Rel_ID = ref_Rel_ID;
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R212_relates_ClassAsSupertype_inst = ClassAsSupertypeImpl.EMPTY_CLASSASSUPERTYPE;
        R213_relates_ClassAsSubtype_set = new ClassAsSubtypeSetImpl();
    }

    public static SubtypeSupertypeAssociation create( Sql context ) throws XtumlException {
        SubtypeSupertypeAssociation newSubtypeSupertypeAssociation = new SubtypeSupertypeAssociationImpl( context );
        if ( context.addInstance( newSubtypeSupertypeAssociation ) ) {
            newSubtypeSupertypeAssociation.getRunContext().addChange(new InstanceCreatedDelta(newSubtypeSupertypeAssociation, KEY_LETTERS));
            return newSubtypeSupertypeAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SubtypeSupertypeAssociation create( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID ) throws XtumlException {
        SubtypeSupertypeAssociation newSubtypeSupertypeAssociation = new SubtypeSupertypeAssociationImpl( context, instanceId, ref_Rel_ID );
        if ( context.addInstance( newSubtypeSupertypeAssociation ) ) {
            return newSubtypeSupertypeAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Rel_ID;
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
                return ref_Rel_ID;
    }
    @Override
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Rel_ID.inequality( this.ref_Rel_ID ) ) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R213_relates_ClassAsSubtype().isEmpty() ) R213_relates_ClassAsSubtype().setRel_ID( ref_Rel_ID );
            if ( !R212_relates_ClassAsSupertype().isEmpty() ) R212_relates_ClassAsSupertype().setRel_ID( ref_Rel_ID );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Association R206_is_a_Association_inst;
    @Override
    public void setR206_is_a_Association( Association inst ) {
        R206_is_a_Association_inst = inst;
    }
    @Override
    public Association R206_is_a_Association() throws XtumlException {
        return R206_is_a_Association_inst;
    }
    private ClassAsSupertype R212_relates_ClassAsSupertype_inst;
    @Override
    public void setR212_relates_ClassAsSupertype( ClassAsSupertype inst ) {
        R212_relates_ClassAsSupertype_inst = inst;
    }
    @Override
    public ClassAsSupertype R212_relates_ClassAsSupertype() throws XtumlException {
        return R212_relates_ClassAsSupertype_inst;
    }
    private ClassAsSubtypeSet R213_relates_ClassAsSubtype_set;
    @Override
    public void addR213_relates_ClassAsSubtype( ClassAsSubtype inst ) {
        R213_relates_ClassAsSubtype_set.add(inst);
    }
    @Override
    public void removeR213_relates_ClassAsSubtype( ClassAsSubtype inst ) {
        R213_relates_ClassAsSubtype_set.remove(inst);
    }
    @Override
    public ClassAsSubtypeSet R213_relates_ClassAsSubtype() throws XtumlException {
        return R213_relates_ClassAsSubtype_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SubtypeSupertypeAssociation value() {
        return this;
    }

    @Override
    public SubtypeSupertypeAssociation self() {
        return this;
    }

    @Override
    public SubtypeSupertypeAssociation oneWhere( IWhere<SubtypeSupertypeAssociation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }

}

class EmptySubtypeSupertypeAssociation extends ModelInstance<SubtypeSupertypeAssociation,Sql> implements SubtypeSupertypeAssociation {

    // attributes
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Association R206_is_a_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }
    @Override
    public ClassAsSupertype R212_relates_ClassAsSupertype() {
        return ClassAsSupertypeImpl.EMPTY_CLASSASSUPERTYPE;
    }
    @Override
    public ClassAsSubtypeSet R213_relates_ClassAsSubtype() {
        return (new ClassAsSubtypeSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return SubtypeSupertypeAssociationImpl.KEY_LETTERS;
    }

    @Override
    public SubtypeSupertypeAssociation value() {
        return this;
    }
    
    @Override
    public SubtypeSupertypeAssociation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SubtypeSupertypeAssociation oneWhere( IWhere<SubtypeSupertypeAssociation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }

}
