package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ControlNode;
import io.ciera.tool.sql.ooaofooa.activity.FlowFinalNode;
import io.ciera.tool.sql.ooaofooa.activity.impl.ControlNodeImpl;


public class FlowFinalNodeImpl extends ModelInstance<FlowFinalNode,Sql> implements FlowFinalNode {

    public static final String KEY_LETTERS = "A_FF";
    public static final FlowFinalNode EMPTY_FLOWFINALNODE = new EmptyFlowFinalNode();

    private Sql context;

    // constructors
    private FlowFinalNodeImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Descrip = "";
        R1106_is_a_ControlNode_inst = ControlNodeImpl.EMPTY_CONTROLNODE;
    }

    private FlowFinalNodeImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Descrip = m_Descrip;
        R1106_is_a_ControlNode_inst = ControlNodeImpl.EMPTY_CONTROLNODE;
    }

    public static FlowFinalNode create( Sql context ) throws XtumlException {
        FlowFinalNode newFlowFinalNode = new FlowFinalNodeImpl( context );
        if ( context.addInstance( newFlowFinalNode ) ) {
            newFlowFinalNode.getRunContext().addChange(new InstanceCreatedDelta(newFlowFinalNode, KEY_LETTERS));
            return newFlowFinalNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FlowFinalNode create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Descrip ) throws XtumlException {
        FlowFinalNode newFlowFinalNode = new FlowFinalNodeImpl( context, instanceId, ref_Id, m_Descrip );
        if ( context.addInstance( newFlowFinalNode ) ) {
            return newFlowFinalNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ControlNode R1106_is_a_ControlNode_inst;
    @Override
    public void setR1106_is_a_ControlNode( ControlNode inst ) {
        R1106_is_a_ControlNode_inst = inst;
    }
    @Override
    public ControlNode R1106_is_a_ControlNode() throws XtumlException {
        return R1106_is_a_ControlNode_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FlowFinalNode value() {
        return this;
    }

    @Override
    public FlowFinalNode self() {
        return this;
    }

    @Override
    public FlowFinalNode oneWhere( IWhere<FlowFinalNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_FLOWFINALNODE;
    }

}

class EmptyFlowFinalNode extends ModelInstance<FlowFinalNode,Sql> implements FlowFinalNode {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ControlNode R1106_is_a_ControlNode() {
        return ControlNodeImpl.EMPTY_CONTROLNODE;
    }


    @Override
    public String getKeyLetters() {
        return FlowFinalNodeImpl.KEY_LETTERS;
    }

    @Override
    public FlowFinalNode value() {
        return this;
    }
    
    @Override
    public FlowFinalNode self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FlowFinalNode oneWhere( IWhere<FlowFinalNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return FlowFinalNodeImpl.EMPTY_FLOWFINALNODE;
    }

}
