package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ActionNode;
import io.ciera.tool.sql.ooaofooa.activity.ActivityEdge;
import io.ciera.tool.sql.ooaofooa.activity.ActivityEdgeSet;
import io.ciera.tool.sql.ooaofooa.activity.ActivityNode;
import io.ciera.tool.sql.ooaofooa.activity.ControlNode;
import io.ciera.tool.sql.ooaofooa.activity.ObjectNode;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActionNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityEdgeSetImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ControlNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ObjectNodeImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class ActivityNodeImpl extends ModelInstance<ActivityNode,Sql> implements ActivityNode {

    public static final String KEY_LETTERS = "A_N";
    public static final ActivityNode EMPTY_ACTIVITYNODE = new EmptyActivityNode();

    private Sql context;

    // constructors
    private ActivityNodeImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Package_IDdeprecated = UniqueId.random();
        R1103_incoming_ActivityEdge_set = new ActivityEdgeSetImpl();
        R1104_outgoing_ActivityEdge_set = new ActivityEdgeSetImpl();
        R1105_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
        R1105_is_a_ControlNode_inst = ControlNodeImpl.EMPTY_CONTROLNODE;
        R1105_is_a_ObjectNode_inst = ObjectNodeImpl.EMPTY_OBJECTNODE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private ActivityNodeImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId m_Package_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Package_IDdeprecated = m_Package_IDdeprecated;
        R1103_incoming_ActivityEdge_set = new ActivityEdgeSetImpl();
        R1104_outgoing_ActivityEdge_set = new ActivityEdgeSetImpl();
        R1105_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
        R1105_is_a_ControlNode_inst = ControlNodeImpl.EMPTY_CONTROLNODE;
        R1105_is_a_ObjectNode_inst = ObjectNodeImpl.EMPTY_OBJECTNODE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static ActivityNode create( Sql context ) throws XtumlException {
        ActivityNode newActivityNode = new ActivityNodeImpl( context );
        if ( context.addInstance( newActivityNode ) ) {
            newActivityNode.getRunContext().addChange(new InstanceCreatedDelta(newActivityNode, KEY_LETTERS));
            return newActivityNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ActivityNode create( Sql context, UniqueId instanceId, UniqueId ref_Id, UniqueId m_Package_IDdeprecated ) throws XtumlException {
        ActivityNode newActivityNode = new ActivityNodeImpl( context, instanceId, ref_Id, m_Package_IDdeprecated );
        if ( context.addInstance( newActivityNode ) ) {
            return newActivityNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R1104_outgoing_ActivityEdge().isEmpty() ) R1104_outgoing_ActivityEdge().setSourceId( ref_Id );
            if ( !R1105_is_a_ControlNode().isEmpty() ) R1105_is_a_ControlNode().setId( ref_Id );
            if ( !R1105_is_a_ObjectNode().isEmpty() ) R1105_is_a_ObjectNode().setId( ref_Id );
            if ( !R1103_incoming_ActivityEdge().isEmpty() ) R1103_incoming_ActivityEdge().setTargetId( ref_Id );
            if ( !R1105_is_a_ActionNode().isEmpty() ) R1105_is_a_ActionNode().setId( ref_Id );
        }
    }
    private UniqueId m_Package_IDdeprecated;
    @Override
    public UniqueId getPackage_IDdeprecated() throws XtumlException {
        checkLiving();
                return m_Package_IDdeprecated;
    }
    @Override
    public void setPackage_IDdeprecated( UniqueId m_Package_IDdeprecated ) throws XtumlException {
        checkLiving();
        if ( m_Package_IDdeprecated.inequality( this.m_Package_IDdeprecated ) ) {
            final UniqueId oldValue = this.m_Package_IDdeprecated;
            this.m_Package_IDdeprecated = m_Package_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Package_IDdeprecated", oldValue, this.m_Package_IDdeprecated));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActivityEdgeSet R1103_incoming_ActivityEdge_set;
    @Override
    public void addR1103_incoming_ActivityEdge( ActivityEdge inst ) {
        R1103_incoming_ActivityEdge_set.add(inst);
    }
    @Override
    public void removeR1103_incoming_ActivityEdge( ActivityEdge inst ) {
        R1103_incoming_ActivityEdge_set.remove(inst);
    }
    @Override
    public ActivityEdgeSet R1103_incoming_ActivityEdge() throws XtumlException {
        return R1103_incoming_ActivityEdge_set;
    }
    private ActivityEdgeSet R1104_outgoing_ActivityEdge_set;
    @Override
    public void addR1104_outgoing_ActivityEdge( ActivityEdge inst ) {
        R1104_outgoing_ActivityEdge_set.add(inst);
    }
    @Override
    public void removeR1104_outgoing_ActivityEdge( ActivityEdge inst ) {
        R1104_outgoing_ActivityEdge_set.remove(inst);
    }
    @Override
    public ActivityEdgeSet R1104_outgoing_ActivityEdge() throws XtumlException {
        return R1104_outgoing_ActivityEdge_set;
    }
    private ActionNode R1105_is_a_ActionNode_inst;
    @Override
    public void setR1105_is_a_ActionNode( ActionNode inst ) {
        R1105_is_a_ActionNode_inst = inst;
    }
    @Override
    public ActionNode R1105_is_a_ActionNode() throws XtumlException {
        return R1105_is_a_ActionNode_inst;
    }
    private ControlNode R1105_is_a_ControlNode_inst;
    @Override
    public void setR1105_is_a_ControlNode( ControlNode inst ) {
        R1105_is_a_ControlNode_inst = inst;
    }
    @Override
    public ControlNode R1105_is_a_ControlNode() throws XtumlException {
        return R1105_is_a_ControlNode_inst;
    }
    private ObjectNode R1105_is_a_ObjectNode_inst;
    @Override
    public void setR1105_is_a_ObjectNode( ObjectNode inst ) {
        R1105_is_a_ObjectNode_inst = inst;
    }
    @Override
    public ObjectNode R1105_is_a_ObjectNode() throws XtumlException {
        return R1105_is_a_ObjectNode_inst;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ActivityNode value() {
        return this;
    }

    @Override
    public ActivityNode self() {
        return this;
    }

    @Override
    public ActivityNode oneWhere( IWhere<ActivityNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ACTIVITYNODE;
    }

}

class EmptyActivityNode extends ModelInstance<ActivityNode,Sql> implements ActivityNode {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPackage_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage_IDdeprecated( UniqueId m_Package_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActivityEdgeSet R1103_incoming_ActivityEdge() {
        return (new ActivityEdgeSetImpl());
    }
    @Override
    public ActivityEdgeSet R1104_outgoing_ActivityEdge() {
        return (new ActivityEdgeSetImpl());
    }
    @Override
    public ActionNode R1105_is_a_ActionNode() {
        return ActionNodeImpl.EMPTY_ACTIONNODE;
    }
    @Override
    public ControlNode R1105_is_a_ControlNode() {
        return ControlNodeImpl.EMPTY_CONTROLNODE;
    }
    @Override
    public ObjectNode R1105_is_a_ObjectNode() {
        return ObjectNodeImpl.EMPTY_OBJECTNODE;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return ActivityNodeImpl.KEY_LETTERS;
    }

    @Override
    public ActivityNode value() {
        return this;
    }
    
    @Override
    public ActivityNode self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ActivityNode oneWhere( IWhere<ActivityNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }

}
