package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ActionNode;
import io.ciera.tool.sql.ooaofooa.activity.ActivityDiagramAction;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActionNodeImpl;


public class ActivityDiagramActionImpl extends ModelInstance<ActivityDiagramAction,Sql> implements ActivityDiagramAction {

    public static final String KEY_LETTERS = "A_GA";
    public static final ActivityDiagramAction EMPTY_ACTIVITYDIAGRAMACTION = new EmptyActivityDiagramAction();

    private Sql context;

    // constructors
    private ActivityDiagramActionImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R1107_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
    }

    private ActivityDiagramActionImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R1107_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
    }

    public static ActivityDiagramAction create( Sql context ) throws XtumlException {
        ActivityDiagramAction newActivityDiagramAction = new ActivityDiagramActionImpl( context );
        if ( context.addInstance( newActivityDiagramAction ) ) {
            newActivityDiagramAction.getRunContext().addChange(new InstanceCreatedDelta(newActivityDiagramAction, KEY_LETTERS));
            return newActivityDiagramAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ActivityDiagramAction create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        ActivityDiagramAction newActivityDiagramAction = new ActivityDiagramActionImpl( context, instanceId, ref_Id, m_Name, m_Descrip );
        if ( context.addInstance( newActivityDiagramAction ) ) {
            return newActivityDiagramAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    private String m_Name;
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActionNode R1107_is_a_ActionNode_inst;
    @Override
    public void setR1107_is_a_ActionNode( ActionNode inst ) {
        R1107_is_a_ActionNode_inst = inst;
    }
    @Override
    public ActionNode R1107_is_a_ActionNode() throws XtumlException {
        return R1107_is_a_ActionNode_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ActivityDiagramAction value() {
        return this;
    }

    @Override
    public ActivityDiagramAction self() {
        return this;
    }

    @Override
    public ActivityDiagramAction oneWhere( IWhere<ActivityDiagramAction> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ACTIVITYDIAGRAMACTION;
    }

}

class EmptyActivityDiagramAction extends ModelInstance<ActivityDiagramAction,Sql> implements ActivityDiagramAction {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActionNode R1107_is_a_ActionNode() {
        return ActionNodeImpl.EMPTY_ACTIONNODE;
    }


    @Override
    public String getKeyLetters() {
        return ActivityDiagramActionImpl.KEY_LETTERS;
    }

    @Override
    public ActivityDiagramAction value() {
        return this;
    }
    
    @Override
    public ActivityDiagramAction self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ActivityDiagramAction oneWhere( IWhere<ActivityDiagramAction> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ActivityDiagramActionImpl.EMPTY_ACTIVITYDIAGRAMACTION;
    }

}
