package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeLoader;
import io.ciera.tool.sql.loader.InstanceLoader;
import io.ciera.tool.sql.loader.TimerInstanceLoader;
import io.ciera.tool.sql.loader.impl.InstanceLoaderImpl;


public class TimerInstanceLoaderImpl extends ModelInstance<TimerInstanceLoader,Sql> implements TimerInstanceLoader {

    public static final String KEY_LETTERS = "TimerInstanceLoader";
    public static final TimerInstanceLoader EMPTY_TIMERINSTANCELOADER = new EmptyTimerInstanceLoader();

    private Sql context;

    // constructors
    private TimerInstanceLoaderImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        R3016_is_a_InstanceLoader_inst = InstanceLoaderImpl.EMPTY_INSTANCELOADER;
    }

    private TimerInstanceLoaderImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        R3016_is_a_InstanceLoader_inst = InstanceLoaderImpl.EMPTY_INSTANCELOADER;
    }

    public static TimerInstanceLoader create( Sql context ) throws XtumlException {
        TimerInstanceLoader newTimerInstanceLoader = new TimerInstanceLoaderImpl( context );
        if ( context.addInstance( newTimerInstanceLoader ) ) {
            newTimerInstanceLoader.getRunContext().addChange(new InstanceCreatedDelta(newTimerInstanceLoader, KEY_LETTERS));
            return newTimerInstanceLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TimerInstanceLoader create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name ) throws XtumlException {
        TimerInstanceLoader newTimerInstanceLoader = new TimerInstanceLoaderImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name );
        if ( context.addInstance( newTimerInstanceLoader ) ) {
            return newTimerInstanceLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
                return ref_loader_name;
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_name, this.ref_loader_name ) ) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
                return ref_loader_package;
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_package, this.ref_loader_package ) ) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
                return ref_class_name;
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_name, this.ref_class_name ) ) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        AttributeLoader attr_loader = self().R3016_is_a_InstanceLoader().R3006_loads_data_value_using_AttributeLoader().any();
        AttributeLoader prev_attr_loader = attr_loader.R3007_follows_AttributeLoader();
        while ( !prev_attr_loader.isEmpty() ) {
            attr_loader = prev_attr_loader;
            prev_attr_loader = attr_loader.R3007_follows_AttributeLoader();
        }
        String sep = "";
        while ( !attr_loader.isEmpty() ) {
            context().T().append( sep );
            attr_loader.render();
            sep = ", ";
            attr_loader = attr_loader.R3007_precedes_AttributeLoader();
        }
        String attribute_loaders = context().T().body();
        context().T().pop_buffer();
        context().T().include( "loader/t.timerinstanceloader.java", attribute_loaders, self() );
    }



    // static operations


    // events


    // selections
    private InstanceLoader R3016_is_a_InstanceLoader_inst;
    @Override
    public void setR3016_is_a_InstanceLoader( InstanceLoader inst ) {
        R3016_is_a_InstanceLoader_inst = inst;
    }
    @Override
    public InstanceLoader R3016_is_a_InstanceLoader() throws XtumlException {
        return R3016_is_a_InstanceLoader_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TimerInstanceLoader value() {
        return this;
    }

    @Override
    public TimerInstanceLoader self() {
        return this;
    }

    @Override
    public TimerInstanceLoader oneWhere( IWhere<TimerInstanceLoader> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_TIMERINSTANCELOADER;
    }

}

class EmptyTimerInstanceLoader extends ModelInstance<TimerInstanceLoader,Sql> implements TimerInstanceLoader {

    // attributes
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InstanceLoader R3016_is_a_InstanceLoader() {
        return InstanceLoaderImpl.EMPTY_INSTANCELOADER;
    }


    @Override
    public String getKeyLetters() {
        return TimerInstanceLoaderImpl.KEY_LETTERS;
    }

    @Override
    public TimerInstanceLoader value() {
        return this;
    }
    
    @Override
    public TimerInstanceLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TimerInstanceLoader oneWhere( IWhere<TimerInstanceLoader> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return TimerInstanceLoaderImpl.EMPTY_TIMERINSTANCELOADER;
    }

}
