package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeSerializer;
import io.ciera.tool.sql.loader.StringSerializer;
import io.ciera.tool.sql.loader.impl.AttributeSerializerImpl;


public class StringSerializerImpl extends ModelInstance<StringSerializer,Sql> implements StringSerializer {

    public static final String KEY_LETTERS = "Z_StringSerializer";
    public static final StringSerializer EMPTY_STRINGSERIALIZER = new EmptyStringSerializer();

    private Sql context;

    // constructors
    private StringSerializerImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        ref_attr_name = "";
        m_value = "";
        R3004_is_a_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }

    private StringSerializerImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String ref_attr_name, String m_value ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        this.ref_attr_name = ref_attr_name;
        this.m_value = m_value;
        R3004_is_a_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }

    public static StringSerializer create( Sql context ) throws XtumlException {
        StringSerializer newStringSerializer = new StringSerializerImpl( context );
        if ( context.addInstance( newStringSerializer ) ) {
            newStringSerializer.getRunContext().addChange(new InstanceCreatedDelta(newStringSerializer, KEY_LETTERS));
            return newStringSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StringSerializer create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String ref_attr_name, String m_value ) throws XtumlException {
        StringSerializer newStringSerializer = new StringSerializerImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name, ref_attr_name, m_value );
        if ( context.addInstance( newStringSerializer ) ) {
            return newStringSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_name, this.ref_loader_name ) ) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
                return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_package, this.ref_loader_package ) ) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
                return ref_loader_package;
    }
    private String ref_class_name;
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_name, this.ref_class_name ) ) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
                return ref_class_name;
    }
    private String ref_attr_name;
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
                return ref_attr_name;
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_attr_name, this.ref_attr_name ) ) {
            final String oldValue = this.ref_attr_name;
            this.ref_attr_name = ref_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_name", oldValue, this.ref_attr_name));
        }
    }
    private String m_value;
    @Override
    public void setValue( String m_value ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_value, this.m_value ) ) {
            final String oldValue = this.m_value;
            this.m_value = m_value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_value", oldValue, this.m_value));
        }
    }
    @Override
    public String getValue() throws XtumlException {
        checkLiving();
                return m_value;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name(), getAttr_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        AttributeSerializer attr_serializer = self().R3004_is_a_AttributeSerializer();
        String cast = attr_serializer.getCast();
        context().T().include( "loader/t.stringserializer.java", cast, self() );
    }



    // static operations


    // events


    // selections
    private AttributeSerializer R3004_is_a_AttributeSerializer_inst;
    @Override
    public void setR3004_is_a_AttributeSerializer( AttributeSerializer inst ) {
        R3004_is_a_AttributeSerializer_inst = inst;
    }
    @Override
    public AttributeSerializer R3004_is_a_AttributeSerializer() throws XtumlException {
        return R3004_is_a_AttributeSerializer_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StringSerializer value() {
        return this;
    }

    @Override
    public StringSerializer self() {
        return this;
    }

    @Override
    public StringSerializer oneWhere( IWhere<StringSerializer> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_STRINGSERIALIZER;
    }

}

class EmptyStringSerializer extends ModelInstance<StringSerializer,Sql> implements StringSerializer {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setValue( String m_value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AttributeSerializer R3004_is_a_AttributeSerializer() {
        return AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }


    @Override
    public String getKeyLetters() {
        return StringSerializerImpl.KEY_LETTERS;
    }

    @Override
    public StringSerializer value() {
        return this;
    }
    
    @Override
    public StringSerializer self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StringSerializer oneWhere( IWhere<StringSerializer> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return StringSerializerImpl.EMPTY_STRINGSERIALIZER;
    }

}
