package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeLoaderSet;
import io.ciera.tool.sql.loader.ClassInstanceLoaderSet;
import io.ciera.tool.sql.loader.EventInstanceLoaderSet;
import io.ciera.tool.sql.loader.InstanceLoader;
import io.ciera.tool.sql.loader.InstanceLoaderSet;
import io.ciera.tool.sql.loader.PopulationLoaderSet;
import io.ciera.tool.sql.loader.TimerInstanceLoaderSet;
import io.ciera.tool.sql.loader.impl.AttributeLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.ClassInstanceLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.EventInstanceLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.PopulationLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.TimerInstanceLoaderSetImpl;

import java.util.Arrays;
import java.util.List;


public class InstanceLoaderSetImpl extends InstanceSet<InstanceLoaderSet,InstanceLoader> implements InstanceLoaderSet {

    // attributes
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( InstanceLoader instanceloader : this ) instanceloader.setLoader_package( ref_loader_package );
    }
    @Override
    public void setClass_name( String m_class_name ) throws XtumlException {
        for ( InstanceLoader instanceloader : this ) instanceloader.setClass_name( m_class_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( InstanceLoader instanceloader : this ) instanceloader.setLoader_name( ref_loader_name );
    }


    // selections
    @Override
    public PopulationLoaderSet R3005_invoked_by_PopulationLoader() throws XtumlException {
        PopulationLoaderSet populationloaderset = new PopulationLoaderSetImpl();
        for ( InstanceLoader instanceloader : this ) populationloaderset.add( instanceloader.R3005_invoked_by_PopulationLoader() );
        return populationloaderset;
    }
    @Override
    public AttributeLoaderSet R3006_loads_data_value_using_AttributeLoader() throws XtumlException {
        AttributeLoaderSet attributeloaderset = new AttributeLoaderSetImpl();
        for ( InstanceLoader instanceloader : this ) attributeloaderset.addAll( instanceloader.R3006_loads_data_value_using_AttributeLoader() );
        return attributeloaderset;
    }
    @Override
    public ClassInstanceLoaderSet R3016_is_a_ClassInstanceLoader() throws XtumlException {
        ClassInstanceLoaderSet classinstanceloaderset = new ClassInstanceLoaderSetImpl();
        for ( InstanceLoader instanceloader : this ) classinstanceloaderset.add( instanceloader.R3016_is_a_ClassInstanceLoader() );
        return classinstanceloaderset;
    }
    @Override
    public EventInstanceLoaderSet R3016_is_a_EventInstanceLoader() throws XtumlException {
        EventInstanceLoaderSet eventinstanceloaderset = new EventInstanceLoaderSetImpl();
        for ( InstanceLoader instanceloader : this ) eventinstanceloaderset.add( instanceloader.R3016_is_a_EventInstanceLoader() );
        return eventinstanceloaderset;
    }
    @Override
    public TimerInstanceLoaderSet R3016_is_a_TimerInstanceLoader() throws XtumlException {
        TimerInstanceLoaderSet timerinstanceloaderset = new TimerInstanceLoaderSetImpl();
        for ( InstanceLoader instanceloader : this ) timerinstanceloaderset.add( instanceloader.R3016_is_a_TimerInstanceLoader() );
        return timerinstanceloaderset;
    }


    @Override
    public InstanceLoader nullElement() {
        return InstanceLoaderImpl.EMPTY_INSTANCELOADER;
    }

    @Override
    public InstanceLoaderSet emptySet() {
      return new InstanceLoaderSetImpl();
    }

    @Override
    public InstanceLoaderSet value() {
        return this;
    }

    @Override
    public List<InstanceLoader> elements() {
        return Arrays.asList(toArray(new InstanceLoader[0]));
    }

}
