package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeSerializer;
import io.ciera.tool.sql.loader.BooleanSerializer;
import io.ciera.tool.sql.loader.GeneralSerializer;
import io.ciera.tool.sql.loader.InstanceSerializer;
import io.ciera.tool.sql.loader.IntegerSerializer;
import io.ciera.tool.sql.loader.RealSerializer;
import io.ciera.tool.sql.loader.StringSerializer;
import io.ciera.tool.sql.loader.UniqueIDSerializer;
import io.ciera.tool.sql.loader.impl.AttributeSerializerImpl;
import io.ciera.tool.sql.loader.impl.BooleanSerializerImpl;
import io.ciera.tool.sql.loader.impl.GeneralSerializerImpl;
import io.ciera.tool.sql.loader.impl.InstanceSerializerImpl;
import io.ciera.tool.sql.loader.impl.IntegerSerializerImpl;
import io.ciera.tool.sql.loader.impl.RealSerializerImpl;
import io.ciera.tool.sql.loader.impl.StringSerializerImpl;
import io.ciera.tool.sql.loader.impl.UniqueIDSerializerImpl;


public class AttributeSerializerImpl extends ModelInstance<AttributeSerializer,Sql> implements AttributeSerializer {

    public static final String KEY_LETTERS = "Z_AttributeSerializer";
    public static final AttributeSerializer EMPTY_ATTRIBUTESERIALIZER = new EmptyAttributeSerializer();

    private Sql context;

    // constructors
    private AttributeSerializerImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        m_attr_name = "";
        ref_prev_attr_name = "";
        m_cast = "";
        R3002_invoked_by_InstanceSerializer_inst = InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
        R3003_follows_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
        R3003_precedes_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
        R3004_is_a_BooleanSerializer_inst = BooleanSerializerImpl.EMPTY_BOOLEANSERIALIZER;
        R3004_is_a_GeneralSerializer_inst = GeneralSerializerImpl.EMPTY_GENERALSERIALIZER;
        R3004_is_a_IntegerSerializer_inst = IntegerSerializerImpl.EMPTY_INTEGERSERIALIZER;
        R3004_is_a_RealSerializer_inst = RealSerializerImpl.EMPTY_REALSERIALIZER;
        R3004_is_a_StringSerializer_inst = StringSerializerImpl.EMPTY_STRINGSERIALIZER;
        R3004_is_a_UniqueIDSerializer_inst = UniqueIDSerializerImpl.EMPTY_UNIQUEIDSERIALIZER;
    }

    private AttributeSerializerImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String m_attr_name, String ref_prev_attr_name, String m_cast ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        this.m_attr_name = m_attr_name;
        this.ref_prev_attr_name = ref_prev_attr_name;
        this.m_cast = m_cast;
        R3002_invoked_by_InstanceSerializer_inst = InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
        R3003_follows_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
        R3003_precedes_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
        R3004_is_a_BooleanSerializer_inst = BooleanSerializerImpl.EMPTY_BOOLEANSERIALIZER;
        R3004_is_a_GeneralSerializer_inst = GeneralSerializerImpl.EMPTY_GENERALSERIALIZER;
        R3004_is_a_IntegerSerializer_inst = IntegerSerializerImpl.EMPTY_INTEGERSERIALIZER;
        R3004_is_a_RealSerializer_inst = RealSerializerImpl.EMPTY_REALSERIALIZER;
        R3004_is_a_StringSerializer_inst = StringSerializerImpl.EMPTY_STRINGSERIALIZER;
        R3004_is_a_UniqueIDSerializer_inst = UniqueIDSerializerImpl.EMPTY_UNIQUEIDSERIALIZER;
    }

    public static AttributeSerializer create( Sql context ) throws XtumlException {
        AttributeSerializer newAttributeSerializer = new AttributeSerializerImpl( context );
        if ( context.addInstance( newAttributeSerializer ) ) {
            newAttributeSerializer.getRunContext().addChange(new InstanceCreatedDelta(newAttributeSerializer, KEY_LETTERS));
            return newAttributeSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeSerializer create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String m_attr_name, String ref_prev_attr_name, String m_cast ) throws XtumlException {
        AttributeSerializer newAttributeSerializer = new AttributeSerializerImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name, m_attr_name, ref_prev_attr_name, m_cast );
        if ( context.addInstance( newAttributeSerializer ) ) {
            return newAttributeSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_name, this.ref_loader_name ) ) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
            if ( !R3004_is_a_UniqueIDSerializer().isEmpty() ) R3004_is_a_UniqueIDSerializer().setLoader_name( ref_loader_name );
            if ( !R3004_is_a_BooleanSerializer().isEmpty() ) R3004_is_a_BooleanSerializer().setLoader_name( ref_loader_name );
            if ( !R3004_is_a_RealSerializer().isEmpty() ) R3004_is_a_RealSerializer().setLoader_name( ref_loader_name );
            if ( !R3003_precedes_AttributeSerializer().isEmpty() ) R3003_precedes_AttributeSerializer().setLoader_name( ref_loader_name );
            if ( !R3004_is_a_GeneralSerializer().isEmpty() ) R3004_is_a_GeneralSerializer().setLoader_name( ref_loader_name );
            if ( !R3004_is_a_StringSerializer().isEmpty() ) R3004_is_a_StringSerializer().setLoader_name( ref_loader_name );
            if ( !R3004_is_a_IntegerSerializer().isEmpty() ) R3004_is_a_IntegerSerializer().setLoader_name( ref_loader_name );
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
                return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
                return ref_loader_package;
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_package, this.ref_loader_package ) ) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
            if ( !R3003_precedes_AttributeSerializer().isEmpty() ) R3003_precedes_AttributeSerializer().setLoader_package( ref_loader_package );
            if ( !R3004_is_a_BooleanSerializer().isEmpty() ) R3004_is_a_BooleanSerializer().setLoader_package( ref_loader_package );
            if ( !R3004_is_a_UniqueIDSerializer().isEmpty() ) R3004_is_a_UniqueIDSerializer().setLoader_package( ref_loader_package );
            if ( !R3004_is_a_IntegerSerializer().isEmpty() ) R3004_is_a_IntegerSerializer().setLoader_package( ref_loader_package );
            if ( !R3004_is_a_StringSerializer().isEmpty() ) R3004_is_a_StringSerializer().setLoader_package( ref_loader_package );
            if ( !R3004_is_a_GeneralSerializer().isEmpty() ) R3004_is_a_GeneralSerializer().setLoader_package( ref_loader_package );
            if ( !R3004_is_a_RealSerializer().isEmpty() ) R3004_is_a_RealSerializer().setLoader_package( ref_loader_package );
        }
    }
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
                return ref_class_name;
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_name, this.ref_class_name ) ) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
            if ( !R3004_is_a_UniqueIDSerializer().isEmpty() ) R3004_is_a_UniqueIDSerializer().setClass_name( ref_class_name );
            if ( !R3004_is_a_GeneralSerializer().isEmpty() ) R3004_is_a_GeneralSerializer().setClass_name( ref_class_name );
            if ( !R3003_precedes_AttributeSerializer().isEmpty() ) R3003_precedes_AttributeSerializer().setClass_name( ref_class_name );
            if ( !R3004_is_a_StringSerializer().isEmpty() ) R3004_is_a_StringSerializer().setClass_name( ref_class_name );
            if ( !R3004_is_a_BooleanSerializer().isEmpty() ) R3004_is_a_BooleanSerializer().setClass_name( ref_class_name );
            if ( !R3004_is_a_RealSerializer().isEmpty() ) R3004_is_a_RealSerializer().setClass_name( ref_class_name );
            if ( !R3004_is_a_IntegerSerializer().isEmpty() ) R3004_is_a_IntegerSerializer().setClass_name( ref_class_name );
        }
    }
    private String m_attr_name;
    @Override
    public void setAttr_name( String m_attr_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_attr_name, this.m_attr_name ) ) {
            final String oldValue = this.m_attr_name;
            this.m_attr_name = m_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_attr_name", oldValue, this.m_attr_name));
            if ( !R3003_precedes_AttributeSerializer().isEmpty() ) R3003_precedes_AttributeSerializer().setPrev_attr_name( m_attr_name );
            if ( !R3004_is_a_RealSerializer().isEmpty() ) R3004_is_a_RealSerializer().setAttr_name( m_attr_name );
            if ( !R3004_is_a_GeneralSerializer().isEmpty() ) R3004_is_a_GeneralSerializer().setAttr_name( m_attr_name );
            if ( !R3004_is_a_IntegerSerializer().isEmpty() ) R3004_is_a_IntegerSerializer().setAttr_name( m_attr_name );
            if ( !R3004_is_a_UniqueIDSerializer().isEmpty() ) R3004_is_a_UniqueIDSerializer().setAttr_name( m_attr_name );
            if ( !R3004_is_a_StringSerializer().isEmpty() ) R3004_is_a_StringSerializer().setAttr_name( m_attr_name );
            if ( !R3004_is_a_BooleanSerializer().isEmpty() ) R3004_is_a_BooleanSerializer().setAttr_name( m_attr_name );
        }
    }
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
                return m_attr_name;
    }
    private String ref_prev_attr_name;
    @Override
    public void setPrev_attr_name( String ref_prev_attr_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_prev_attr_name, this.ref_prev_attr_name ) ) {
            final String oldValue = this.ref_prev_attr_name;
            this.ref_prev_attr_name = ref_prev_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_prev_attr_name", oldValue, this.ref_prev_attr_name));
        }
    }
    @Override
    public String getPrev_attr_name() throws XtumlException {
        checkLiving();
                return ref_prev_attr_name;
    }
    private String m_cast;
    @Override
    public String getCast() throws XtumlException {
        checkLiving();
                return m_cast;
    }
    @Override
    public void setCast( String m_cast ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_cast, this.m_cast ) ) {
            final String oldValue = this.m_cast;
            this.m_cast = m_cast;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_cast", oldValue, this.m_cast));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name(), getAttr_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        GeneralSerializer generalserializer = self().R3004_is_a_GeneralSerializer();
        if ( !generalserializer.isEmpty() ) {
            generalserializer.render();
        }
        else {
            IntegerSerializer integerserializer = self().R3004_is_a_IntegerSerializer();
            if ( !integerserializer.isEmpty() ) {
                integerserializer.render();
            }
            else {
                UniqueIDSerializer uniqueidserializer = self().R3004_is_a_UniqueIDSerializer();
                if ( !uniqueidserializer.isEmpty() ) {
                    uniqueidserializer.render();
                }
                else {
                    RealSerializer realserializer = self().R3004_is_a_RealSerializer();
                    if ( !realserializer.isEmpty() ) {
                        realserializer.render();
                    }
                    else {
                        BooleanSerializer booleanserializer = self().R3004_is_a_BooleanSerializer();
                        if ( !booleanserializer.isEmpty() ) {
                            booleanserializer.render();
                        }
                        else {
                            StringSerializer stringserializer = self().R3004_is_a_StringSerializer();
                            if ( !stringserializer.isEmpty() ) {
                                stringserializer.render();
                            }
                            else {
                                throw new XtumlException("No subtype selected");
                            }
                        }
                    }
                }
            }
        }
    }



    // static operations


    // events


    // selections
    private InstanceSerializer R3002_invoked_by_InstanceSerializer_inst;
    @Override
    public void setR3002_invoked_by_InstanceSerializer( InstanceSerializer inst ) {
        R3002_invoked_by_InstanceSerializer_inst = inst;
    }
    @Override
    public InstanceSerializer R3002_invoked_by_InstanceSerializer() throws XtumlException {
        return R3002_invoked_by_InstanceSerializer_inst;
    }
    private AttributeSerializer R3003_follows_AttributeSerializer_inst;
    @Override
    public void setR3003_follows_AttributeSerializer( AttributeSerializer inst ) {
        R3003_follows_AttributeSerializer_inst = inst;
    }
    @Override
    public AttributeSerializer R3003_follows_AttributeSerializer() throws XtumlException {
        return R3003_follows_AttributeSerializer_inst;
    }
    private AttributeSerializer R3003_precedes_AttributeSerializer_inst;
    @Override
    public void setR3003_precedes_AttributeSerializer( AttributeSerializer inst ) {
        R3003_precedes_AttributeSerializer_inst = inst;
    }
    @Override
    public AttributeSerializer R3003_precedes_AttributeSerializer() throws XtumlException {
        return R3003_precedes_AttributeSerializer_inst;
    }
    private BooleanSerializer R3004_is_a_BooleanSerializer_inst;
    @Override
    public void setR3004_is_a_BooleanSerializer( BooleanSerializer inst ) {
        R3004_is_a_BooleanSerializer_inst = inst;
    }
    @Override
    public BooleanSerializer R3004_is_a_BooleanSerializer() throws XtumlException {
        return R3004_is_a_BooleanSerializer_inst;
    }
    private GeneralSerializer R3004_is_a_GeneralSerializer_inst;
    @Override
    public void setR3004_is_a_GeneralSerializer( GeneralSerializer inst ) {
        R3004_is_a_GeneralSerializer_inst = inst;
    }
    @Override
    public GeneralSerializer R3004_is_a_GeneralSerializer() throws XtumlException {
        return R3004_is_a_GeneralSerializer_inst;
    }
    private IntegerSerializer R3004_is_a_IntegerSerializer_inst;
    @Override
    public void setR3004_is_a_IntegerSerializer( IntegerSerializer inst ) {
        R3004_is_a_IntegerSerializer_inst = inst;
    }
    @Override
    public IntegerSerializer R3004_is_a_IntegerSerializer() throws XtumlException {
        return R3004_is_a_IntegerSerializer_inst;
    }
    private RealSerializer R3004_is_a_RealSerializer_inst;
    @Override
    public void setR3004_is_a_RealSerializer( RealSerializer inst ) {
        R3004_is_a_RealSerializer_inst = inst;
    }
    @Override
    public RealSerializer R3004_is_a_RealSerializer() throws XtumlException {
        return R3004_is_a_RealSerializer_inst;
    }
    private StringSerializer R3004_is_a_StringSerializer_inst;
    @Override
    public void setR3004_is_a_StringSerializer( StringSerializer inst ) {
        R3004_is_a_StringSerializer_inst = inst;
    }
    @Override
    public StringSerializer R3004_is_a_StringSerializer() throws XtumlException {
        return R3004_is_a_StringSerializer_inst;
    }
    private UniqueIDSerializer R3004_is_a_UniqueIDSerializer_inst;
    @Override
    public void setR3004_is_a_UniqueIDSerializer( UniqueIDSerializer inst ) {
        R3004_is_a_UniqueIDSerializer_inst = inst;
    }
    @Override
    public UniqueIDSerializer R3004_is_a_UniqueIDSerializer() throws XtumlException {
        return R3004_is_a_UniqueIDSerializer_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeSerializer value() {
        return this;
    }

    @Override
    public AttributeSerializer self() {
        return this;
    }

    @Override
    public AttributeSerializer oneWhere( IWhere<AttributeSerializer> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ATTRIBUTESERIALIZER;
    }

}

class EmptyAttributeSerializer extends ModelInstance<AttributeSerializer,Sql> implements AttributeSerializer {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAttr_name( String m_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrev_attr_name( String ref_prev_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPrev_attr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getCast() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCast( String m_cast ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InstanceSerializer R3002_invoked_by_InstanceSerializer() {
        return InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
    }
    @Override
    public AttributeSerializer R3003_follows_AttributeSerializer() {
        return AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }
    @Override
    public AttributeSerializer R3003_precedes_AttributeSerializer() {
        return AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }
    @Override
    public BooleanSerializer R3004_is_a_BooleanSerializer() {
        return BooleanSerializerImpl.EMPTY_BOOLEANSERIALIZER;
    }
    @Override
    public GeneralSerializer R3004_is_a_GeneralSerializer() {
        return GeneralSerializerImpl.EMPTY_GENERALSERIALIZER;
    }
    @Override
    public IntegerSerializer R3004_is_a_IntegerSerializer() {
        return IntegerSerializerImpl.EMPTY_INTEGERSERIALIZER;
    }
    @Override
    public RealSerializer R3004_is_a_RealSerializer() {
        return RealSerializerImpl.EMPTY_REALSERIALIZER;
    }
    @Override
    public StringSerializer R3004_is_a_StringSerializer() {
        return StringSerializerImpl.EMPTY_STRINGSERIALIZER;
    }
    @Override
    public UniqueIDSerializer R3004_is_a_UniqueIDSerializer() {
        return UniqueIDSerializerImpl.EMPTY_UNIQUEIDSERIALIZER;
    }


    @Override
    public String getKeyLetters() {
        return AttributeSerializerImpl.KEY_LETTERS;
    }

    @Override
    public AttributeSerializer value() {
        return this;
    }
    
    @Override
    public AttributeSerializer self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeSerializer oneWhere( IWhere<AttributeSerializer> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }

}
