package io.ciera.tool.sql.compiler.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.compiler.CIERA;
import io.ciera.tool.sql.compiler.CIERASet;

import java.util.Arrays;
import java.util.List;


public class CIERASetImpl extends InstanceSet<CIERASet,CIERA> implements CIERASet {

    // attributes
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( CIERA ciera : this ) ciera.setName( m_name );
    }
    @Override
    public void setProjectroot( String m_projectroot ) throws XtumlException {
        for ( CIERA ciera : this ) ciera.setProjectroot( m_projectroot );
    }
    @Override
    public void setVersion( String m_version ) throws XtumlException {
        for ( CIERA ciera : this ) ciera.setVersion( m_version );
    }


    // selections


    @Override
    public CIERA nullElement() {
        return CIERAImpl.EMPTY_CIERA;
    }

    @Override
    public CIERASet emptySet() {
      return new CIERASetImpl();
    }

    @Override
    public CIERASet value() {
        return this;
    }

    @Override
    public List<CIERA> elements() {
        CIERA[] elements = toArray(new CIERA[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
