package io.ciera.tool.sql.architecture.type;


import io.ciera.runtime.summit.classes.IModelInstance;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.type.Enumerator;
import io.ciera.tool.sql.architecture.type.EnumeratorSet;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.loader.EnumeratorLoader;
import io.ciera.tool.sql.loader.EnumeratorLoaderSet;


public interface EnumeratedType extends IModelInstance<EnumeratedType,Sql> {

    // attributes
    public String getName() throws XtumlException;
    public void setName( String ref_name ) throws XtumlException;
    public void setPackage( String ref_package ) throws XtumlException;
    public String getPackage() throws XtumlException;


    // operations
    public void render() throws XtumlException;


    // selections
    default public void addR3010_EnumeratorLoader( EnumeratorLoader inst ) {}
    default public void removeR3010_EnumeratorLoader( EnumeratorLoader inst ) {}
    public EnumeratorLoaderSet R3010_EnumeratorLoader() throws XtumlException;
    default public void setR401_is_a_File( File inst ) {}
    public File R401_is_a_File() throws XtumlException;
    default public void setR407_is_a_Type( Type inst ) {}
    public Type R407_is_a_Type() throws XtumlException;
    default public void addR415_declares_Enumerator( Enumerator inst ) {}
    default public void removeR415_declares_Enumerator( Enumerator inst ) {}
    public EnumeratorSet R415_declares_Enumerator() throws XtumlException;


}
