package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.relationship.impl.ClassRelationshipSetImpl;
import io.ciera.tool.sql.architecture.statement.RelateSmt;
import io.ciera.tool.sql.architecture.statement.RelateSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.List;


public class RelateSmtSetImpl extends InstanceSet<RelateSmtSet,RelateSmt> implements RelateSmtSet {

    // attributes
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setComp_name( ref_comp_name );
    }
    @Override
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setRel_name( ref_rel_name );
    }
    @Override
    public void setForm_expression_number( String ref_form_expression_number ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setForm_expression_number( ref_form_expression_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setParent_package( ref_parent_package );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setBlock_number( ref_block_number );
    }
    @Override
    public void setPart_expression_number( String ref_part_expression_number ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setPart_expression_number( ref_part_expression_number );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setComp_package( ref_comp_package );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setBody_name( ref_body_name );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( RelateSmt relatesmt : this ) relatesmt.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( RelateSmt relatesmt : this ) statementset.add( relatesmt.R451_is_a_Statement() );
        return statementset;
    }
    @Override
    public ExpressionSet R479_relates_formalizing_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( RelateSmt relatesmt : this ) expressionset.add( relatesmt.R479_relates_formalizing_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R480_relates_participating_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( RelateSmt relatesmt : this ) expressionset.add( relatesmt.R480_relates_participating_Expression() );
        return expressionset;
    }
    @Override
    public ClassRelationshipSet R481_creates_instances_of_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( RelateSmt relatesmt : this ) classrelationshipset.add( relatesmt.R481_creates_instances_of_ClassRelationship() );
        return classrelationshipset;
    }


    @Override
    public RelateSmt nullElement() {
        return RelateSmtImpl.EMPTY_RELATESMT;
    }

    @Override
    public RelateSmtSet emptySet() {
      return new RelateSmtSetImpl();
    }

    @Override
    public RelateSmtSet value() {
        return this;
    }

    @Override
    public List<RelateSmt> elements() {
        return Arrays.asList(toArray(new RelateSmt[0]));
    }

}
