package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.statement.Finalization;
import io.ciera.tool.sql.architecture.statement.FinalizationSet;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.Variable;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;


public class FinalizationImpl extends ModelInstance<Finalization,Sql> implements Finalization {

    public static final String KEY_LETTERS = "Finalization";
    public static final Finalization EMPTY_FINALIZATION = new EmptyFinalization();

    private Sql context;

    // constructors
    private FinalizationImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_body_name = "";
        ref_var_name = "";
        ref_var_block_number = "";
        R485_finalized_by_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R485_finalizes_Variable_inst = VariableImpl.EMPTY_VARIABLE;
    }

    private FinalizationImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_block_number, String ref_statement_number, String ref_body_name, String ref_var_name, String ref_var_block_number ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_body_name = ref_body_name;
        this.ref_var_name = ref_var_name;
        this.ref_var_block_number = ref_var_block_number;
        R485_finalized_by_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R485_finalizes_Variable_inst = VariableImpl.EMPTY_VARIABLE;
    }

    public static Finalization create( Sql context ) throws XtumlException {
        Finalization newFinalization = new FinalizationImpl( context );
        if ( context.addInstance( newFinalization ) ) {
            newFinalization.getRunContext().addChange(new InstanceCreatedDelta(newFinalization, KEY_LETTERS));
            return newFinalization;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Finalization create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_block_number, String ref_statement_number, String ref_body_name, String ref_var_name, String ref_var_block_number ) throws XtumlException {
        Finalization newFinalization = new FinalizationImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_block_number, ref_statement_number, ref_body_name, ref_var_name, ref_var_block_number );
        if ( context.addInstance( newFinalization ) ) {
            return newFinalization;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
                return ref_parent_name;
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_name, this.ref_parent_name ) ) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_package, this.ref_parent_package ) ) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
                return ref_parent_package;
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
                return ref_block_number;
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_block_number, this.ref_block_number ) ) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_statement_number, this.ref_statement_number ) ) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
                return ref_statement_number;
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
                return ref_body_name;
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_body_name, this.ref_body_name ) ) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_var_name;
    @Override
    public String getVar_name() throws XtumlException {
        checkLiving();
                return ref_var_name;
    }
    @Override
    public void setVar_name( String ref_var_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_var_name, this.ref_var_name ) ) {
            final String oldValue = this.ref_var_name;
            this.ref_var_name = ref_var_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_var_name", oldValue, this.ref_var_name));
        }
    }
    private String ref_var_block_number;
    @Override
    public String getVar_block_number() throws XtumlException {
        checkLiving();
                return ref_var_block_number;
    }
    @Override
    public void setVar_block_number( String ref_var_block_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_var_block_number, this.ref_var_block_number ) ) {
            final String oldValue = this.ref_var_block_number;
            this.ref_var_block_number = ref_var_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_var_block_number", oldValue, this.ref_var_block_number));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBlock_number(), getStatement_number(), getBody_name(), getVar_name(), getVar_block_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        Variable var = self().R485_finalizes_Variable();
        FinalizationSet previous_finalizations = var.R485_finalized_by_Finalization().where( selected -> StringUtil.lessThan( selected.getBlock_number(), self().getBlock_number() ) || StringUtil.equality( selected.getBlock_number(), self().getBlock_number() ) && StringUtil.lessThan( selected.getStatement_number(), self().getStatement_number() ) );
        int finalization_num = previous_finalizations.size();
        TypeReference var_type = var.R461_is_typed_by_TypeReference();
        String type_name = var_type.getType_reference_name();
        Statement smt = self().R485_finalized_by_Statement();
        CodeBlock block = smt.R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( block.getTab_depth() + 1 );
        context().T().push_buffer();
        context().T().include( "statement/t.finalization.java", finalization_num, indent, self(), type_name );
        smt.setPrefix( smt.getPrefix() + context().T().body() );
        context().T().pop_buffer();
    }



    // static operations


    // events


    // selections
    private Statement R485_finalized_by_Statement_inst;
    @Override
    public void setR485_finalized_by_Statement( Statement inst ) {
        R485_finalized_by_Statement_inst = inst;
    }
    @Override
    public Statement R485_finalized_by_Statement() throws XtumlException {
        return R485_finalized_by_Statement_inst;
    }
    private Variable R485_finalizes_Variable_inst;
    @Override
    public void setR485_finalizes_Variable( Variable inst ) {
        R485_finalizes_Variable_inst = inst;
    }
    @Override
    public Variable R485_finalizes_Variable() throws XtumlException {
        return R485_finalizes_Variable_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Finalization value() {
        return this;
    }

    @Override
    public Finalization self() {
        return this;
    }

    @Override
    public Finalization oneWhere( IWhere<Finalization> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_FINALIZATION;
    }

}

class EmptyFinalization extends ModelInstance<Finalization,Sql> implements Finalization {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getVar_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_name( String ref_var_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getVar_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_block_number( String ref_var_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R485_finalized_by_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public Variable R485_finalizes_Variable() {
        return VariableImpl.EMPTY_VARIABLE;
    }


    @Override
    public String getKeyLetters() {
        return FinalizationImpl.KEY_LETTERS;
    }

    @Override
    public Finalization value() {
        return this;
    }
    
    @Override
    public Finalization self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Finalization oneWhere( IWhere<Finalization> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return FinalizationImpl.EMPTY_FINALIZATION;
    }

}
