package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterImpl;
import io.ciera.tool.sql.architecture.statemachine.Event;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCell;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRow;
import io.ciera.tool.sql.architecture.statemachine.impl.EventImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.StateImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableRowImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;

import types.TransitionType;


public class TransitionTableCellImpl extends ModelInstance<TransitionTableCell,Sql> implements TransitionTableCell {

    public static final String KEY_LETTERS = "TransitionTableCell";
    public static final TransitionTableCell EMPTY_TRANSITIONTABLECELL = new EmptyTransitionTableCell();

    private Sql context;

    // constructors
    private TransitionTableCellImpl( Sql context ) {
        this.context = context;
        ref_sm_name = "";
        ref_sm_package = "";
        ref_state_name = "";
        ref_event_sm_name = "";
        ref_event_sm_package = "";
        ref_event_name = "";
        ref_end_state_name = "";
        m_transition_type = TransitionType.UNINITIALIZED_ENUM;
        m_index = 0;
        R4755_TransitionTableRow_inst = TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
        R4756_receives_Event_inst = EventImpl.EMPTY_EVENT;
        R4757_transitions_to_State_inst = StateImpl.EMPTY_STATE;
    }

    private TransitionTableCellImpl( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_state_name, String ref_event_sm_name, String ref_event_sm_package, String ref_event_name, String ref_end_state_name, TransitionType m_transition_type, int m_index ) {
        super(instanceId);
        this.context = context;
        this.ref_sm_name = ref_sm_name;
        this.ref_sm_package = ref_sm_package;
        this.ref_state_name = ref_state_name;
        this.ref_event_sm_name = ref_event_sm_name;
        this.ref_event_sm_package = ref_event_sm_package;
        this.ref_event_name = ref_event_name;
        this.ref_end_state_name = ref_end_state_name;
        this.m_transition_type = m_transition_type;
        this.m_index = m_index;
        R4755_TransitionTableRow_inst = TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
        R4756_receives_Event_inst = EventImpl.EMPTY_EVENT;
        R4757_transitions_to_State_inst = StateImpl.EMPTY_STATE;
    }

    public static TransitionTableCell create( Sql context ) throws XtumlException {
        TransitionTableCell newTransitionTableCell = new TransitionTableCellImpl( context );
        if ( context.addInstance( newTransitionTableCell ) ) {
            newTransitionTableCell.getRunContext().addChange(new InstanceCreatedDelta(newTransitionTableCell, KEY_LETTERS));
            return newTransitionTableCell;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TransitionTableCell create( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_state_name, String ref_event_sm_name, String ref_event_sm_package, String ref_event_name, String ref_end_state_name, TransitionType m_transition_type, int m_index ) throws XtumlException {
        TransitionTableCell newTransitionTableCell = new TransitionTableCellImpl( context, instanceId, ref_sm_name, ref_sm_package, ref_state_name, ref_event_sm_name, ref_event_sm_package, ref_event_name, ref_end_state_name, m_transition_type, m_index );
        if ( context.addInstance( newTransitionTableCell ) ) {
            return newTransitionTableCell;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_sm_name;
    @Override
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_sm_name, this.ref_sm_name ) ) {
            final String oldValue = this.ref_sm_name;
            this.ref_sm_name = ref_sm_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_name", oldValue, this.ref_sm_name));
        }
    }
    @Override
    public String getSm_name() throws XtumlException {
        checkLiving();
                return ref_sm_name;
    }
    private String ref_sm_package;
    @Override
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_sm_package, this.ref_sm_package ) ) {
            final String oldValue = this.ref_sm_package;
            this.ref_sm_package = ref_sm_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_package", oldValue, this.ref_sm_package));
        }
    }
    @Override
    public String getSm_package() throws XtumlException {
        checkLiving();
                return ref_sm_package;
    }
    private String ref_state_name;
    @Override
    public String getState_name() throws XtumlException {
        checkLiving();
                return ref_state_name;
    }
    @Override
    public void setState_name( String ref_state_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_state_name, this.ref_state_name ) ) {
            final String oldValue = this.ref_state_name;
            this.ref_state_name = ref_state_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_state_name", oldValue, this.ref_state_name));
        }
    }
    private String ref_event_sm_name;
    @Override
    public String getEvent_sm_name() throws XtumlException {
        checkLiving();
                return ref_event_sm_name;
    }
    @Override
    public void setEvent_sm_name( String ref_event_sm_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_event_sm_name, this.ref_event_sm_name ) ) {
            final String oldValue = this.ref_event_sm_name;
            this.ref_event_sm_name = ref_event_sm_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_event_sm_name", oldValue, this.ref_event_sm_name));
        }
    }
    private String ref_event_sm_package;
    @Override
    public String getEvent_sm_package() throws XtumlException {
        checkLiving();
                return ref_event_sm_package;
    }
    @Override
    public void setEvent_sm_package( String ref_event_sm_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_event_sm_package, this.ref_event_sm_package ) ) {
            final String oldValue = this.ref_event_sm_package;
            this.ref_event_sm_package = ref_event_sm_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_event_sm_package", oldValue, this.ref_event_sm_package));
        }
    }
    private String ref_event_name;
    @Override
    public String getEvent_name() throws XtumlException {
        checkLiving();
                return ref_event_name;
    }
    @Override
    public void setEvent_name( String ref_event_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_event_name, this.ref_event_name ) ) {
            final String oldValue = this.ref_event_name;
            this.ref_event_name = ref_event_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_event_name", oldValue, this.ref_event_name));
        }
    }
    private String ref_end_state_name;
    @Override
    public void setEnd_state_name( String ref_end_state_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_end_state_name, this.ref_end_state_name ) ) {
            final String oldValue = this.ref_end_state_name;
            this.ref_end_state_name = ref_end_state_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_end_state_name", oldValue, this.ref_end_state_name));
        }
    }
    @Override
    public String getEnd_state_name() throws XtumlException {
        checkLiving();
                return ref_end_state_name;
    }
    private TransitionType m_transition_type;
    @Override
    public TransitionType getTransition_type() throws XtumlException {
        checkLiving();
                return m_transition_type;
    }
    @Override
    public void setTransition_type( TransitionType m_transition_type ) throws XtumlException {
        checkLiving();
        if ( m_transition_type.inequality( this.m_transition_type ) ) {
            final TransitionType oldValue = this.m_transition_type;
            this.m_transition_type = m_transition_type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_transition_type", oldValue, this.m_transition_type));
        }
    }
    private int m_index;
    @Override
    public void setIndex( int m_index ) throws XtumlException {
        checkLiving();
        if ( m_index != this.m_index ) {
            final int oldValue = this.m_index;
            this.m_index = m_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_index", oldValue, this.m_index));
        }
    }
    @Override
    public int getIndex() throws XtumlException {
        checkLiving();
                return m_index;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSm_name(), getSm_package(), getState_name(), getEvent_sm_name(), getEvent_sm_package(), getEvent_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        boolean cant_happen = self().getTransition_type().equality( TransitionType.CANT_HAPPEN );
        boolean event_ignored = self().getTransition_type().equality( TransitionType.IGNORE );
        String parameter_list = "";
        InvocableObject invocable = self().R4756_receives_Event().R427_is_a_InvocableObject();
        FormalParameter parm = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        FormalParameter prev_parm = invocable.R429_declares_signature_with_FormalParameter().any();
        while ( !prev_parm.isEmpty() ) {
            parm = prev_parm;
            prev_parm = parm.R404_follows_FormalParameter();
        }
        String separator = "";
        int i = 0;
        while ( !parm.isEmpty() ) {
            TypeReference parm_type = parm.R431_is_typed_by_TypeReference();
            parameter_list = ( ( ( ( ( parameter_list + separator ) + "(" ) + parm_type.getType_reference_name() ) + ")event.get(" ) + context().STRING().itoa( i ) ) + ")";
            separator = ",  ";
            parm = parm.R404_precedes_FormalParameter();
            i = i + 1;
        }
        context().T().include( "statemachine/t.transitiontablecell.java", cant_happen, event_ignored, parameter_list, self() );
    }



    // static operations


    // events


    // selections
    private TransitionTableRow R4755_TransitionTableRow_inst;
    @Override
    public void setR4755_TransitionTableRow( TransitionTableRow inst ) {
        R4755_TransitionTableRow_inst = inst;
    }
    @Override
    public TransitionTableRow R4755_TransitionTableRow() throws XtumlException {
        return R4755_TransitionTableRow_inst;
    }
    private Event R4756_receives_Event_inst;
    @Override
    public void setR4756_receives_Event( Event inst ) {
        R4756_receives_Event_inst = inst;
    }
    @Override
    public Event R4756_receives_Event() throws XtumlException {
        return R4756_receives_Event_inst;
    }
    private State R4757_transitions_to_State_inst;
    @Override
    public void setR4757_transitions_to_State( State inst ) {
        R4757_transitions_to_State_inst = inst;
    }
    @Override
    public State R4757_transitions_to_State() throws XtumlException {
        return R4757_transitions_to_State_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TransitionTableCell value() {
        return this;
    }

    @Override
    public TransitionTableCell self() {
        return this;
    }

    @Override
    public TransitionTableCell oneWhere( IWhere<TransitionTableCell> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_TRANSITIONTABLECELL;
    }

}

class EmptyTransitionTableCell extends ModelInstance<TransitionTableCell,Sql> implements TransitionTableCell {

    // attributes
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getState_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setState_name( String ref_state_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEvent_sm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_sm_name( String ref_event_sm_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEvent_sm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_sm_package( String ref_event_sm_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEvent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_name( String ref_event_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setEnd_state_name( String ref_end_state_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEnd_state_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public TransitionType getTransition_type() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTransition_type( TransitionType m_transition_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIndex( int m_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getIndex() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public TransitionTableRow R4755_TransitionTableRow() {
        return TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
    }
    @Override
    public Event R4756_receives_Event() {
        return EventImpl.EMPTY_EVENT;
    }
    @Override
    public State R4757_transitions_to_State() {
        return StateImpl.EMPTY_STATE;
    }


    @Override
    public String getKeyLetters() {
        return TransitionTableCellImpl.KEY_LETTERS;
    }

    @Override
    public TransitionTableCell value() {
        return this;
    }
    
    @Override
    public TransitionTableCell self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TransitionTableCell oneWhere( IWhere<TransitionTableCell> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return TransitionTableCellImpl.EMPTY_TRANSITIONTABLECELL;
    }

}
