package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;
import io.ciera.tool.sql.architecture.statemachine.Event;
import io.ciera.tool.sql.architecture.statemachine.EventSet;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.StateSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRow;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRowSet;
import io.ciera.tool.sql.architecture.statemachine.impl.EventSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.StateSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableRowSetImpl;

import java.util.Iterator;

import types.ImportType;


public class StateMachineImpl extends ModelInstance<StateMachine,Sql> implements StateMachine {

    public static final String KEY_LETTERS = "StateMachine";
    public static final StateMachine EMPTY_STATEMACHINE = new EmptyStateMachine();

    private Sql context;

    // constructors
    private StateMachineImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        ref_class_name = "";
        ref_comp_name = "";
        ref_comp_package = "";
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R4750_models_behavior_of_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R4751_declares_State_set = new StateSetImpl();
        R4752_declares_Event_set = new EventSetImpl();
        R4753_transitions_defined_by_TransitionTableRow_set = new TransitionTableRowSetImpl();
    }

    private StateMachineImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_class_name, String ref_comp_name, String ref_comp_package ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.ref_class_name = ref_class_name;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R4750_models_behavior_of_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R4751_declares_State_set = new StateSetImpl();
        R4752_declares_Event_set = new EventSetImpl();
        R4753_transitions_defined_by_TransitionTableRow_set = new TransitionTableRowSetImpl();
    }

    public static StateMachine create( Sql context ) throws XtumlException {
        StateMachine newStateMachine = new StateMachineImpl( context );
        if ( context.addInstance( newStateMachine ) ) {
            newStateMachine.getRunContext().addChange(new InstanceCreatedDelta(newStateMachine, KEY_LETTERS));
            return newStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StateMachine create( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_class_name, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        StateMachine newStateMachine = new StateMachineImpl( context, instanceId, ref_name, ref_package, ref_class_name, ref_comp_name, ref_comp_package );
        if ( context.addInstance( newStateMachine ) ) {
            return newStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R4752_declares_Event().isEmpty() ) R4752_declares_Event().setSm_name( ref_name );
            if ( !R4753_transitions_defined_by_TransitionTableRow().isEmpty() ) R4753_transitions_defined_by_TransitionTableRow().setSm_name( ref_name );
            if ( !R4751_declares_State().isEmpty() ) R4751_declares_State().setSm_name( ref_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    private String ref_package;
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_package, this.ref_package ) ) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R4752_declares_Event().isEmpty() ) R4752_declares_Event().setSm_package( ref_package );
            if ( !R4753_transitions_defined_by_TransitionTableRow().isEmpty() ) R4753_transitions_defined_by_TransitionTableRow().setSm_package( ref_package );
            if ( !R4751_declares_State().isEmpty() ) R4751_declares_State().setSm_package( ref_package );
        }
    }
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
                return ref_package;
    }
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
                return ref_class_name;
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_name, this.ref_class_name ) ) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    private String ref_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
                return ref_comp_name;
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_name, this.ref_comp_name ) ) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
                return ref_comp_package;
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_package, this.ref_comp_package ) ) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        String imports = file.getFormattedImports( ImportType.IMPL );
        String initial_state = "";
        State init_state = self().R4751_declares_State().anyWhere( selected -> selected.getNumber() == 0 );
        if ( !init_state.isEmpty() ) {
            initial_state = init_state.getName();
        }
        StateSet states = self().R4751_declares_State();
        State state;
        for ( Iterator<State> _state_iter = states.elements().iterator(); _state_iter.hasNext(); ) {
            state = _state_iter.next();
            state.render_decl();
        }
        String state_declarations = context().T().body();
        context().T().clear();
        for ( Iterator<State> _state_iter = states.elements().iterator(); _state_iter.hasNext(); ) {
            state = _state_iter.next();
            state.render();
        }
        String state_actions = context().T().body();
        context().T().clear();
        int index = 0;
        String sep = "";
        final int _final0_index = index;
        TransitionTableRow row = self().R4753_transitions_defined_by_TransitionTableRow().anyWhere( selected -> selected.getIndex() == _final0_index );
        while ( !row.isEmpty() ) {
            context().T().append( sep );
            row.render();
            index = index + 1;
            sep = ",\n";
            final int _final1_index = index;
            row = self().R4753_transitions_defined_by_TransitionTableRow().anyWhere( selected -> selected.getIndex() == _final1_index );
        }
        String transition_table_rows = context().T().body();
        context().T().clear();
        context().T().include( "statemachine/t.statemachine.java", imports, initial_state, self(), state_actions, state_declarations, transition_table_rows );
        context().T().emit( ( ( file.getPath() + "/impl/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }

    @Override
    public void render_decl() throws XtumlException {
        context().T().include( "statemachine/t.statemachine.decl.java", self() );
    }



    // static operations


    // events


    // selections
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }
    private ModelInst R4750_models_behavior_of_ModelInst_inst;
    @Override
    public void setR4750_models_behavior_of_ModelInst( ModelInst inst ) {
        R4750_models_behavior_of_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R4750_models_behavior_of_ModelInst() throws XtumlException {
        return R4750_models_behavior_of_ModelInst_inst;
    }
    private StateSet R4751_declares_State_set;
    @Override
    public void addR4751_declares_State( State inst ) {
        R4751_declares_State_set.add(inst);
    }
    @Override
    public void removeR4751_declares_State( State inst ) {
        R4751_declares_State_set.remove(inst);
    }
    @Override
    public StateSet R4751_declares_State() throws XtumlException {
        return R4751_declares_State_set;
    }
    private EventSet R4752_declares_Event_set;
    @Override
    public void addR4752_declares_Event( Event inst ) {
        R4752_declares_Event_set.add(inst);
    }
    @Override
    public void removeR4752_declares_Event( Event inst ) {
        R4752_declares_Event_set.remove(inst);
    }
    @Override
    public EventSet R4752_declares_Event() throws XtumlException {
        return R4752_declares_Event_set;
    }
    private TransitionTableRowSet R4753_transitions_defined_by_TransitionTableRow_set;
    @Override
    public void addR4753_transitions_defined_by_TransitionTableRow( TransitionTableRow inst ) {
        R4753_transitions_defined_by_TransitionTableRow_set.add(inst);
    }
    @Override
    public void removeR4753_transitions_defined_by_TransitionTableRow( TransitionTableRow inst ) {
        R4753_transitions_defined_by_TransitionTableRow_set.remove(inst);
    }
    @Override
    public TransitionTableRowSet R4753_transitions_defined_by_TransitionTableRow() throws XtumlException {
        return R4753_transitions_defined_by_TransitionTableRow_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StateMachine value() {
        return this;
    }

    @Override
    public StateMachine self() {
        return this;
    }

    @Override
    public StateMachine oneWhere( IWhere<StateMachine> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_STATEMACHINE;
    }

}

class EmptyStateMachine extends ModelInstance<StateMachine,Sql> implements StateMachine {

    // attributes
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_decl() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public ModelInst R4750_models_behavior_of_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public StateSet R4751_declares_State() {
        return (new StateSetImpl());
    }
    @Override
    public EventSet R4752_declares_Event() {
        return (new EventSetImpl());
    }
    @Override
    public TransitionTableRowSet R4753_transitions_defined_by_TransitionTableRow() {
        return (new TransitionTableRowSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return StateMachineImpl.KEY_LETTERS;
    }

    @Override
    public StateMachine value() {
        return this;
    }
    
    @Override
    public StateMachine self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StateMachine oneWhere( IWhere<StateMachine> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return StateMachineImpl.EMPTY_STATEMACHINE;
    }

}
