package io.ciera.tool.sql.architecture.invocable.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ActualParameterSet;
import io.ciera.tool.sql.architecture.expression.ParameterReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.ActualParameterSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ParameterReferenceSetImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.FormalParameterSet;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterSetImpl;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceSetImpl;

import java.util.Arrays;
import java.util.List;


public class FormalParameterSetImpl extends InstanceSet<FormalParameterSet,FormalParameter> implements FormalParameterSet {

    // attributes
    @Override
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setType_reference_name( ref_type_reference_name );
    }
    @Override
    public void setInvocable_name( String ref_invocable_name ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setInvocable_name( ref_invocable_name );
    }
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setType_name( ref_type_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setParent_name( ref_parent_name );
    }
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setType_package( ref_type_package );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setName( m_name );
    }
    @Override
    public void setNext_name( String ref_next_name ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setNext_name( ref_next_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setParent_package( ref_parent_package );
    }
    @Override
    public void setBy_ref( boolean m_by_ref ) throws XtumlException {
        for ( FormalParameter formalparameter : this ) formalparameter.setBy_ref( m_by_ref );
    }


    // selections
    @Override
    public ActualParameterSet R3904_ActualParameter() throws XtumlException {
        ActualParameterSet actualparameterset = new ActualParameterSetImpl();
        for ( FormalParameter formalparameter : this ) actualparameterset.addAll( formalparameter.R3904_ActualParameter() );
        return actualparameterset;
    }
    @Override
    public FormalParameterSet R404_follows_FormalParameter() throws XtumlException {
        FormalParameterSet formalparameterset = new FormalParameterSetImpl();
        for ( FormalParameter formalparameter : this ) formalparameterset.add( formalparameter.R404_follows_FormalParameter() );
        return formalparameterset;
    }
    @Override
    public FormalParameterSet R404_precedes_FormalParameter() throws XtumlException {
        FormalParameterSet formalparameterset = new FormalParameterSetImpl();
        for ( FormalParameter formalparameter : this ) formalparameterset.add( formalparameter.R404_precedes_FormalParameter() );
        return formalparameterset;
    }
    @Override
    public InvocableObjectSet R429_shapes_data_for_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( FormalParameter formalparameter : this ) invocableobjectset.add( formalparameter.R429_shapes_data_for_InvocableObject() );
        return invocableobjectset;
    }
    @Override
    public TypeReferenceSet R431_is_typed_by_TypeReference() throws XtumlException {
        TypeReferenceSet typereferenceset = new TypeReferenceSetImpl();
        for ( FormalParameter formalparameter : this ) typereferenceset.add( formalparameter.R431_is_typed_by_TypeReference() );
        return typereferenceset;
    }
    @Override
    public ParameterReferenceSet R781_referenced_by_ParameterReference() throws XtumlException {
        ParameterReferenceSet parameterreferenceset = new ParameterReferenceSetImpl();
        for ( FormalParameter formalparameter : this ) parameterreferenceset.addAll( formalparameter.R781_referenced_by_ParameterReference() );
        return parameterreferenceset;
    }


    @Override
    public FormalParameter nullElement() {
        return FormalParameterImpl.EMPTY_FORMALPARAMETER;
    }

    @Override
    public FormalParameterSet emptySet() {
      return new FormalParameterSetImpl();
    }

    @Override
    public FormalParameterSet value() {
        return this;
    }

    @Override
    public List<FormalParameter> elements() {
        FormalParameter[] elements = toArray(new FormalParameter[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
