package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.file.TypeImport;
import io.ciera.tool.sql.architecture.file.TypeImportReferenceSet;
import io.ciera.tool.sql.architecture.file.TypeImportSet;
import io.ciera.tool.sql.architecture.file.impl.TypeImportReferenceSetImpl;

import java.util.Arrays;
import java.util.List;


public class TypeImportSetImpl extends InstanceSet<TypeImportSet,TypeImport> implements TypeImportSet {

    // attributes
    @Override
    public void setFully_qualified_name( String m_fully_qualified_name ) throws XtumlException {
        for ( TypeImport typeimport : this ) typeimport.setFully_qualified_name( m_fully_qualified_name );
    }


    // selections
    @Override
    public TypeImportReferenceSet R402_imports_type_into_context_of_TypeImportReference() throws XtumlException {
        TypeImportReferenceSet typeimportreferenceset = new TypeImportReferenceSetImpl();
        for ( TypeImport typeimport : this ) typeimportreferenceset.addAll( typeimport.R402_imports_type_into_context_of_TypeImportReference() );
        return typeimportreferenceset;
    }


    @Override
    public TypeImport nullElement() {
        return TypeImportImpl.EMPTY_TYPEIMPORT;
    }

    @Override
    public TypeImportSet emptySet() {
      return new TypeImportSetImpl();
    }

    @Override
    public TypeImportSet value() {
        return this;
    }

    @Override
    public List<TypeImport> elements() {
        return Arrays.asList(toArray(new TypeImport[0]));
    }

}
