package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.GeneralFile;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.impl.PopulationLoaderImpl;


public class GeneralFileImpl extends ModelInstance<GeneralFile,Sql> implements GeneralFile {

    public static final String KEY_LETTERS = "GeneralFile";
    public static final GeneralFile EMPTY_GENERALFILE = new EmptyGeneralFile();

    private Sql context;

    // constructors
    private GeneralFileImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        m_contents = "";
        R3009_is_a_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
    }

    private GeneralFileImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, String m_contents ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.m_contents = m_contents;
        R3009_is_a_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
    }

    public static GeneralFile create( Sql context ) throws XtumlException {
        GeneralFile newGeneralFile = new GeneralFileImpl( context );
        if ( context.addInstance( newGeneralFile ) ) {
            newGeneralFile.getRunContext().addChange(new InstanceCreatedDelta(newGeneralFile, KEY_LETTERS));
            return newGeneralFile;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static GeneralFile create( Sql context, UniqueId instanceId, String ref_name, String ref_package, String m_contents ) throws XtumlException {
        GeneralFile newGeneralFile = new GeneralFileImpl( context, instanceId, ref_name, ref_package, m_contents );
        if ( context.addInstance( newGeneralFile ) ) {
            return newGeneralFile;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R3009_is_a_PopulationLoader().isEmpty() ) R3009_is_a_PopulationLoader().setName( ref_name );
        }
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
                return ref_package;
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_package, this.ref_package ) ) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R3009_is_a_PopulationLoader().isEmpty() ) R3009_is_a_PopulationLoader().setPackage( ref_package );
        }
    }
    private String m_contents;
    @Override
    public String getContents() throws XtumlException {
        checkLiving();
                return m_contents;
    }
    @Override
    public void setContents( String m_contents ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_contents, this.m_contents ) ) {
            final String oldValue = this.m_contents;
            this.m_contents = m_contents;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_contents", oldValue, this.m_contents));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        context().T().include( "file/t.generalfile.java", self() );
        context().T().emit( ( ( file.getPath() + "/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }



    // static operations


    // events


    // selections
    private PopulationLoader R3009_is_a_PopulationLoader_inst;
    @Override
    public void setR3009_is_a_PopulationLoader( PopulationLoader inst ) {
        R3009_is_a_PopulationLoader_inst = inst;
    }
    @Override
    public PopulationLoader R3009_is_a_PopulationLoader() throws XtumlException {
        return R3009_is_a_PopulationLoader_inst;
    }
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public GeneralFile value() {
        return this;
    }

    @Override
    public GeneralFile self() {
        return this;
    }

    @Override
    public GeneralFile oneWhere( IWhere<GeneralFile> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_GENERALFILE;
    }

}

class EmptyGeneralFile extends ModelInstance<GeneralFile,Sql> implements GeneralFile {

    // attributes
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getContents() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setContents( String m_contents ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public PopulationLoader R3009_is_a_PopulationLoader() {
        return PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
    }
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }


    @Override
    public String getKeyLetters() {
        return GeneralFileImpl.KEY_LETTERS;
    }

    @Override
    public GeneralFile value() {
        return this;
    }
    
    @Override
    public GeneralFile self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public GeneralFile oneWhere( IWhere<GeneralFile> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return GeneralFileImpl.EMPTY_GENERALFILE;
    }

}
