package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.component.UtilityReference;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilityImpl;


public class UtilityReferenceImpl extends ModelInstance<UtilityReference,Sql> implements UtilityReference {

    public static final String KEY_LETTERS = "UtilityReference";
    public static final UtilityReference EMPTY_UTILITYREFERENCE = new EmptyUtilityReference();

    private Sql context;

    // constructors
    private UtilityReferenceImpl( Sql context ) {
        this.context = context;
        ref_comp_name = "";
        ref_comp_package = "";
        ref_utility_name = "";
        ref_utility_package = "";
        R4558_contains_Utility_inst = UtilityImpl.EMPTY_UTILITY;
        R4558_used_within_context_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }

    private UtilityReferenceImpl( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String ref_utility_name, String ref_utility_package ) {
        super(instanceId);
        this.context = context;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        this.ref_utility_name = ref_utility_name;
        this.ref_utility_package = ref_utility_package;
        R4558_contains_Utility_inst = UtilityImpl.EMPTY_UTILITY;
        R4558_used_within_context_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }

    public static UtilityReference create( Sql context ) throws XtumlException {
        UtilityReference newUtilityReference = new UtilityReferenceImpl( context );
        if ( context.addInstance( newUtilityReference ) ) {
            newUtilityReference.getRunContext().addChange(new InstanceCreatedDelta(newUtilityReference, KEY_LETTERS));
            return newUtilityReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static UtilityReference create( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String ref_utility_name, String ref_utility_package ) throws XtumlException {
        UtilityReference newUtilityReference = new UtilityReferenceImpl( context, instanceId, ref_comp_name, ref_comp_package, ref_utility_name, ref_utility_package );
        if ( context.addInstance( newUtilityReference ) ) {
            return newUtilityReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
                return ref_comp_name;
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_name, this.ref_comp_name ) ) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    private String ref_comp_package;
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_package, this.ref_comp_package ) ) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
                return ref_comp_package;
    }
    private String ref_utility_name;
    @Override
    public void setUtility_name( String ref_utility_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_utility_name, this.ref_utility_name ) ) {
            final String oldValue = this.ref_utility_name;
            this.ref_utility_name = ref_utility_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_utility_name", oldValue, this.ref_utility_name));
        }
    }
    @Override
    public String getUtility_name() throws XtumlException {
        checkLiving();
                return ref_utility_name;
    }
    private String ref_utility_package;
    @Override
    public String getUtility_package() throws XtumlException {
        checkLiving();
                return ref_utility_package;
    }
    @Override
    public void setUtility_package( String ref_utility_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_utility_package, this.ref_utility_package ) ) {
            final String oldValue = this.ref_utility_package;
            this.ref_utility_package = ref_utility_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_utility_package", oldValue, this.ref_utility_package));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getComp_name(), getComp_package(), getUtility_name(), getUtility_package());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "component/t.utilityreference.java", self() );
    }



    // static operations


    // events


    // selections
    private Utility R4558_contains_Utility_inst;
    @Override
    public void setR4558_contains_Utility( Utility inst ) {
        R4558_contains_Utility_inst = inst;
    }
    @Override
    public Utility R4558_contains_Utility() throws XtumlException {
        return R4558_contains_Utility_inst;
    }
    private ComponentDefinition R4558_used_within_context_of_ComponentDefinition_inst;
    @Override
    public void setR4558_used_within_context_of_ComponentDefinition( ComponentDefinition inst ) {
        R4558_used_within_context_of_ComponentDefinition_inst = inst;
    }
    @Override
    public ComponentDefinition R4558_used_within_context_of_ComponentDefinition() throws XtumlException {
        return R4558_used_within_context_of_ComponentDefinition_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public UtilityReference value() {
        return this;
    }

    @Override
    public UtilityReference self() {
        return this;
    }

    @Override
    public UtilityReference oneWhere( IWhere<UtilityReference> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_UTILITYREFERENCE;
    }

}

class EmptyUtilityReference extends ModelInstance<UtilityReference,Sql> implements UtilityReference {

    // attributes
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setUtility_name( String ref_utility_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getUtility_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getUtility_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setUtility_package( String ref_utility_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Utility R4558_contains_Utility() {
        return UtilityImpl.EMPTY_UTILITY;
    }
    @Override
    public ComponentDefinition R4558_used_within_context_of_ComponentDefinition() {
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }


    @Override
    public String getKeyLetters() {
        return UtilityReferenceImpl.KEY_LETTERS;
    }

    @Override
    public UtilityReference value() {
        return this;
    }
    
    @Override
    public UtilityReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public UtilityReference oneWhere( IWhere<UtilityReference> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return UtilityReferenceImpl.EMPTY_UTILITYREFERENCE;
    }

}
