package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.component.CardinalityCheck;
import io.ciera.tool.sql.architecture.component.CardinalityCheckSet;

import java.util.Arrays;
import java.util.List;


public class CardinalityCheckSetImpl extends InstanceSet<CardinalityCheckSet,CardinalityCheck> implements CardinalityCheckSet {

    // attributes
    @Override
    public void setParticipant( String m_participant ) throws XtumlException {
        for ( CardinalityCheck cardinalitycheck : this ) cardinalitycheck.setParticipant( m_participant );
    }
    @Override
    public void setRelationship_set_cast( String m_relationship_set_cast ) throws XtumlException {
        for ( CardinalityCheck cardinalitycheck : this ) cardinalitycheck.setRelationship_set_cast( m_relationship_set_cast );
    }


    // selections


    @Override
    public CardinalityCheck nullElement() {
        return CardinalityCheckImpl.EMPTY_CARDINALITYCHECK;
    }

    @Override
    public CardinalityCheckSet emptySet() {
      return new CardinalityCheckSetImpl();
    }

    @Override
    public CardinalityCheckSet value() {
        return this;
    }

    @Override
    public List<CardinalityCheck> elements() {
        return Arrays.asList(toArray(new CardinalityCheck[0]));
    }

}
