package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.Operation;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;


public class OperationImpl extends ModelInstance<Operation,Sql> implements Operation {

    public static final String KEY_LETTERS = "Operation";
    public static final Operation EMPTY_OPERATION = new EmptyOperation();

    private Sql context;

    // constructors
    private OperationImpl( Sql context ) {
        this.context = context;
        ref_class_name = "";
        ref_class_package = "";
        ref_name = "";
        m_is_class_based = false;
        ref_comp_name = "";
        ref_comp_package = "";
        R416_provided_by_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }

    private OperationImpl( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String ref_name, boolean m_is_class_based, String ref_comp_name, String ref_comp_package ) {
        super(instanceId);
        this.context = context;
        this.ref_class_name = ref_class_name;
        this.ref_class_package = ref_class_package;
        this.ref_name = ref_name;
        this.m_is_class_based = m_is_class_based;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        R416_provided_by_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }

    public static Operation create( Sql context ) throws XtumlException {
        Operation newOperation = new OperationImpl( context );
        if ( context.addInstance( newOperation ) ) {
            newOperation.getRunContext().addChange(new InstanceCreatedDelta(newOperation, KEY_LETTERS));
            return newOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Operation create( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String ref_name, boolean m_is_class_based, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        Operation newOperation = new OperationImpl( context, instanceId, ref_class_name, ref_class_package, ref_name, m_is_class_based, ref_comp_name, ref_comp_package );
        if ( context.addInstance( newOperation ) ) {
            return newOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
                return ref_class_name;
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_name, this.ref_class_name ) ) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    private String ref_class_package;
    @Override
    public void setClass_package( String ref_class_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_package, this.ref_class_package ) ) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
        }
    }
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
                return ref_class_package;
    }
    private String ref_name;
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    private boolean m_is_class_based;
    @Override
    public boolean getIs_class_based() throws XtumlException {
        checkLiving();
                return m_is_class_based;
    }
    @Override
    public void setIs_class_based( boolean m_is_class_based ) throws XtumlException {
        checkLiving();
        if ( m_is_class_based != this.m_is_class_based ) {
            final boolean oldValue = this.m_is_class_based;
            this.m_is_class_based = m_is_class_based;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_class_based", oldValue, this.m_is_class_based));
        }
    }
    private String ref_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
                return ref_comp_name;
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_name, this.ref_comp_name ) ) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
                return ref_comp_package;
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_package, this.ref_comp_package ) ) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getClass_name(), getClass_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String modifiers = invocable.modifiers();
        TypeReference type = self().R427_is_a_InvocableObject().R428_return_value_is_typed_by_TypeReference();
        String type_name = type.getType_reference_name();
        context().T().push_buffer();
        String parameter_list = invocable.parameter_list();
        String body = invocable.body();
        context().T().pop_buffer();
        context().T().include( "class/t.operation.java", body, modifiers, parameter_list, self(), type_name );
    }

    @Override
    public void render_empty() throws XtumlException {
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String modifiers = invocable.modifiers();
        if ( self().getIs_class_based() ) {
            modifiers = modifiers + "static ";
        }
        TypeReference type = self().R427_is_a_InvocableObject().R428_return_value_is_typed_by_TypeReference();
        String type_name = type.getType_reference_name();
        String parameter_list = invocable.parameter_list();
        context().T().include( "class/t.operation.empty.java", modifiers, parameter_list, self(), type_name );
    }

    @Override
    public void render_interface() throws XtumlException {
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String modifiers = invocable.modifiers();
        if ( self().getIs_class_based() ) {
            modifiers = modifiers + "static ";
        }
        TypeReference type = self().R427_is_a_InvocableObject().R428_return_value_is_typed_by_TypeReference();
        String type_name = type.getType_reference_name();
        String parameter_list = invocable.parameter_list();
        context().T().include( "class/t.operation.int.java", modifiers, parameter_list, self(), type_name );
    }



    // static operations


    // events


    // selections
    private ModelInst R416_provided_by_ModelInst_inst;
    @Override
    public void setR416_provided_by_ModelInst( ModelInst inst ) {
        R416_provided_by_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R416_provided_by_ModelInst() throws XtumlException {
        return R416_provided_by_ModelInst_inst;
    }
    private InvocableObject R427_is_a_InvocableObject_inst;
    @Override
    public void setR427_is_a_InvocableObject( InvocableObject inst ) {
        R427_is_a_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() throws XtumlException {
        return R427_is_a_InvocableObject_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Operation value() {
        return this;
    }

    @Override
    public Operation self() {
        return this;
    }

    @Override
    public Operation oneWhere( IWhere<Operation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_OPERATION;
    }

}

class EmptyOperation extends ModelInstance<Operation,Sql> implements Operation {

    // attributes
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getIs_class_based() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_class_based( boolean m_is_class_based ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_empty() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_interface() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ModelInst R416_provided_by_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }


    @Override
    public String getKeyLetters() {
        return OperationImpl.KEY_LETTERS;
    }

    @Override
    public Operation value() {
        return this;
    }
    
    @Override
    public Operation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Operation oneWhere( IWhere<Operation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return OperationImpl.EMPTY_OPERATION;
    }

}
