package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.AttributeAccessorSet;
import io.ciera.tool.sql.architecture.classes.AttributeReference;
import io.ciera.tool.sql.architecture.classes.AttributeReferenceSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.AttributeAccessorSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.AttributeReferenceSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.expression.AttributeAccess;
import io.ciera.tool.sql.architecture.expression.AttributeAccessSet;
import io.ciera.tool.sql.architecture.expression.Where;
import io.ciera.tool.sql.architecture.expression.WhereSet;
import io.ciera.tool.sql.architecture.expression.impl.AttributeAccessSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.WhereSetImpl;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;


public class AttributeImpl extends ModelInstance<Attribute,Sql> implements Attribute {

    public static final String KEY_LETTERS = "Attribute";
    public static final Attribute EMPTY_ATTRIBUTE = new EmptyAttribute();

    private Sql context;

    // constructors
    private AttributeImpl( Sql context ) {
        this.context = context;
        ref_class_name = "";
        ref_class_package = "";
        m_name = "";
        m_base_name = "";
        ref_Attr_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_comp_name = "";
        ref_comp_package = "";
        m_order = 0;
        ref_type_name = "";
        ref_type_package = "";
        ref_type_reference_name = "";
        m_identifier = 0;
        m_default_value = "";
        R3906_used_as_sort_field_for_Where_set = new WhereSetImpl();
        R410_abstracts_data_for_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R414_is_transformed_from_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R424_is_typed_by_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R4506_has_value_provided_by_AttributeReference_set = new AttributeReferenceSetImpl();
        R4506_provides_value_for_AttributeReference_set = new AttributeReferenceSetImpl();
        R4510_value_accessed_through_AttributeAccessor_set = new AttributeAccessorSetImpl();
        R788_is_referenced_by_AttributeAccess_set = new AttributeAccessSetImpl();
    }

    private AttributeImpl( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String m_name, String m_base_name, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, String ref_comp_name, String ref_comp_package, int m_order, String ref_type_name, String ref_type_package, String ref_type_reference_name, int m_identifier, String m_default_value ) {
        super(instanceId);
        this.context = context;
        this.ref_class_name = ref_class_name;
        this.ref_class_package = ref_class_package;
        this.m_name = m_name;
        this.m_base_name = m_base_name;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        this.m_order = m_order;
        this.ref_type_name = ref_type_name;
        this.ref_type_package = ref_type_package;
        this.ref_type_reference_name = ref_type_reference_name;
        this.m_identifier = m_identifier;
        this.m_default_value = m_default_value;
        R3906_used_as_sort_field_for_Where_set = new WhereSetImpl();
        R410_abstracts_data_for_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R414_is_transformed_from_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R424_is_typed_by_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R4506_has_value_provided_by_AttributeReference_set = new AttributeReferenceSetImpl();
        R4506_provides_value_for_AttributeReference_set = new AttributeReferenceSetImpl();
        R4510_value_accessed_through_AttributeAccessor_set = new AttributeAccessorSetImpl();
        R788_is_referenced_by_AttributeAccess_set = new AttributeAccessSetImpl();
    }

    public static Attribute create( Sql context ) throws XtumlException {
        Attribute newAttribute = new AttributeImpl( context );
        if ( context.addInstance( newAttribute ) ) {
            newAttribute.getRunContext().addChange(new InstanceCreatedDelta(newAttribute, KEY_LETTERS));
            return newAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Attribute create( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String m_name, String m_base_name, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, String ref_comp_name, String ref_comp_package, int m_order, String ref_type_name, String ref_type_package, String ref_type_reference_name, int m_identifier, String m_default_value ) throws XtumlException {
        Attribute newAttribute = new AttributeImpl( context, instanceId, ref_class_name, ref_class_package, m_name, m_base_name, ref_Attr_ID, ref_Obj_ID, ref_comp_name, ref_comp_package, m_order, ref_type_name, ref_type_package, ref_type_reference_name, m_identifier, m_default_value );
        if ( context.addInstance( newAttribute ) ) {
            return newAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
                return ref_class_name;
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_name, this.ref_class_name ) ) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
            if ( !R4506_provides_value_for_AttributeReference().isEmpty() ) R4506_provides_value_for_AttributeReference().setReferred_to_attribute_class_name( ref_class_name );
            if ( !R3906_used_as_sort_field_for_Where().isEmpty() ) R3906_used_as_sort_field_for_Where().setAttr_class_name( ref_class_name );
            if ( !R788_is_referenced_by_AttributeAccess().isEmpty() ) R788_is_referenced_by_AttributeAccess().setAttr_name( ref_class_name );
            if ( !R4506_has_value_provided_by_AttributeReference().isEmpty() ) R4506_has_value_provided_by_AttributeReference().setReferring_attribute_class_name( ref_class_name );
            if ( !R4510_value_accessed_through_AttributeAccessor().isEmpty() ) R4510_value_accessed_through_AttributeAccessor().setClass_name( ref_class_name );
        }
    }
    private String ref_class_package;
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
                return ref_class_package;
    }
    @Override
    public void setClass_package( String ref_class_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_package, this.ref_class_package ) ) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
            if ( !R4510_value_accessed_through_AttributeAccessor().isEmpty() ) R4510_value_accessed_through_AttributeAccessor().setClass_package( ref_class_package );
            if ( !R3906_used_as_sort_field_for_Where().isEmpty() ) R3906_used_as_sort_field_for_Where().setAttr_class_package( ref_class_package );
            if ( !R4506_has_value_provided_by_AttributeReference().isEmpty() ) R4506_has_value_provided_by_AttributeReference().setReferring_attribute_class_package( ref_class_package );
            if ( !R4506_provides_value_for_AttributeReference().isEmpty() ) R4506_provides_value_for_AttributeReference().setReferred_to_attribute_class_package( ref_class_package );
            if ( !R788_is_referenced_by_AttributeAccess().isEmpty() ) R788_is_referenced_by_AttributeAccess().setAttr_class_package( ref_class_package );
        }
    }
    private String m_name;
    @Override
    public void setName( String m_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_name, this.m_name ) ) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R4510_value_accessed_through_AttributeAccessor().isEmpty() ) R4510_value_accessed_through_AttributeAccessor().setAttribute_name( m_name );
            if ( !R4506_has_value_provided_by_AttributeReference().isEmpty() ) R4506_has_value_provided_by_AttributeReference().setReferring_attribute_name( m_name );
            if ( !R3906_used_as_sort_field_for_Where().isEmpty() ) R3906_used_as_sort_field_for_Where().setAttr_name( m_name );
            if ( !R788_is_referenced_by_AttributeAccess().isEmpty() ) R788_is_referenced_by_AttributeAccess().setAttr_class_name( m_name );
            if ( !R4506_provides_value_for_AttributeReference().isEmpty() ) R4506_provides_value_for_AttributeReference().setReferred_to_attribute_name( m_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_name;
    }
    private String m_base_name;
    @Override
    public void setBase_name( String m_base_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_base_name, this.m_base_name ) ) {
            final String oldValue = this.m_base_name;
            this.m_base_name = m_base_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_base_name", oldValue, this.m_base_name));
        }
    }
    @Override
    public String getBase_name() throws XtumlException {
        checkLiving();
                return m_base_name;
    }
    private UniqueId ref_Attr_ID;
    @Override
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Attr_ID.inequality( this.ref_Attr_ID ) ) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
                return ref_Attr_ID;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }
    private String ref_comp_name;
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_name, this.ref_comp_name ) ) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
                return ref_comp_name;
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
                return ref_comp_package;
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_package, this.ref_comp_package ) ) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }
    private int m_order;
    @Override
    public int getOrder() throws XtumlException {
        checkLiving();
                return m_order;
    }
    @Override
    public void setOrder( int m_order ) throws XtumlException {
        checkLiving();
        if ( m_order != this.m_order ) {
            final int oldValue = this.m_order;
            this.m_order = m_order;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_order", oldValue, this.m_order));
        }
    }
    private String ref_type_name;
    @Override
    public String getType_name() throws XtumlException {
        checkLiving();
                return ref_type_name;
    }
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_type_name, this.ref_type_name ) ) {
            final String oldValue = this.ref_type_name;
            this.ref_type_name = ref_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_name", oldValue, this.ref_type_name));
        }
    }
    private String ref_type_package;
    @Override
    public String getType_package() throws XtumlException {
        checkLiving();
                return ref_type_package;
    }
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_type_package, this.ref_type_package ) ) {
            final String oldValue = this.ref_type_package;
            this.ref_type_package = ref_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_package", oldValue, this.ref_type_package));
        }
    }
    private String ref_type_reference_name;
    @Override
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_type_reference_name, this.ref_type_reference_name ) ) {
            final String oldValue = this.ref_type_reference_name;
            this.ref_type_reference_name = ref_type_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_reference_name", oldValue, this.ref_type_reference_name));
        }
    }
    @Override
    public String getType_reference_name() throws XtumlException {
        checkLiving();
                return ref_type_reference_name;
    }
    private int m_identifier;
    @Override
    public int getIdentifier() throws XtumlException {
        checkLiving();
                return m_identifier;
    }
    @Override
    public void setIdentifier( int m_identifier ) throws XtumlException {
        checkLiving();
        if ( m_identifier != this.m_identifier ) {
            final int oldValue = this.m_identifier;
            this.m_identifier = m_identifier;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_identifier", oldValue, this.m_identifier));
        }
    }
    private String m_default_value;
    @Override
    public String getDefault_value() throws XtumlException {
        checkLiving();
                return m_default_value;
    }
    @Override
    public void setDefault_value( String m_default_value ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_default_value, this.m_default_value ) ) {
            final String oldValue = this.m_default_value;
            this.m_default_value = m_default_value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_default_value", oldValue, this.m_default_value));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getClass_name(), getClass_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "class/t.attribute.java", self() );
    }

    @Override
    public void render_initializer() throws XtumlException {
        Type type = self().R424_is_typed_by_TypeReference().R3800_based_on_Type();
        String initializer = self().getDefault_value();
        if ( StringUtil.equality( "", initializer ) ) {
            initializer = type.getDefault_value();
        }
        context().T().include( "class/t.attributeinitializer.java", initializer, self() );
    }



    // static operations


    // events


    // selections
    private WhereSet R3906_used_as_sort_field_for_Where_set;
    @Override
    public void addR3906_used_as_sort_field_for_Where( Where inst ) {
        R3906_used_as_sort_field_for_Where_set.add(inst);
    }
    @Override
    public void removeR3906_used_as_sort_field_for_Where( Where inst ) {
        R3906_used_as_sort_field_for_Where_set.remove(inst);
    }
    @Override
    public WhereSet R3906_used_as_sort_field_for_Where() throws XtumlException {
        return R3906_used_as_sort_field_for_Where_set;
    }
    private ModelInst R410_abstracts_data_for_ModelInst_inst;
    @Override
    public void setR410_abstracts_data_for_ModelInst( ModelInst inst ) {
        R410_abstracts_data_for_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R410_abstracts_data_for_ModelInst() throws XtumlException {
        return R410_abstracts_data_for_ModelInst_inst;
    }
    private O_ATTR R414_is_transformed_from_O_ATTR_inst;
    @Override
    public void setR414_is_transformed_from_O_ATTR( O_ATTR inst ) {
        R414_is_transformed_from_O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R414_is_transformed_from_O_ATTR() throws XtumlException {
        return R414_is_transformed_from_O_ATTR_inst;
    }
    private TypeReference R424_is_typed_by_TypeReference_inst;
    @Override
    public void setR424_is_typed_by_TypeReference( TypeReference inst ) {
        R424_is_typed_by_TypeReference_inst = inst;
    }
    @Override
    public TypeReference R424_is_typed_by_TypeReference() throws XtumlException {
        return R424_is_typed_by_TypeReference_inst;
    }
    private AttributeReferenceSet R4506_has_value_provided_by_AttributeReference_set;
    @Override
    public void addR4506_has_value_provided_by_AttributeReference( AttributeReference inst ) {
        R4506_has_value_provided_by_AttributeReference_set.add(inst);
    }
    @Override
    public void removeR4506_has_value_provided_by_AttributeReference( AttributeReference inst ) {
        R4506_has_value_provided_by_AttributeReference_set.remove(inst);
    }
    @Override
    public AttributeReferenceSet R4506_has_value_provided_by_AttributeReference() throws XtumlException {
        return R4506_has_value_provided_by_AttributeReference_set;
    }
    private AttributeReferenceSet R4506_provides_value_for_AttributeReference_set;
    @Override
    public void addR4506_provides_value_for_AttributeReference( AttributeReference inst ) {
        R4506_provides_value_for_AttributeReference_set.add(inst);
    }
    @Override
    public void removeR4506_provides_value_for_AttributeReference( AttributeReference inst ) {
        R4506_provides_value_for_AttributeReference_set.remove(inst);
    }
    @Override
    public AttributeReferenceSet R4506_provides_value_for_AttributeReference() throws XtumlException {
        return R4506_provides_value_for_AttributeReference_set;
    }
    private AttributeAccessorSet R4510_value_accessed_through_AttributeAccessor_set;
    @Override
    public void addR4510_value_accessed_through_AttributeAccessor( AttributeAccessor inst ) {
        R4510_value_accessed_through_AttributeAccessor_set.add(inst);
    }
    @Override
    public void removeR4510_value_accessed_through_AttributeAccessor( AttributeAccessor inst ) {
        R4510_value_accessed_through_AttributeAccessor_set.remove(inst);
    }
    @Override
    public AttributeAccessorSet R4510_value_accessed_through_AttributeAccessor() throws XtumlException {
        return R4510_value_accessed_through_AttributeAccessor_set;
    }
    private AttributeAccessSet R788_is_referenced_by_AttributeAccess_set;
    @Override
    public void addR788_is_referenced_by_AttributeAccess( AttributeAccess inst ) {
        R788_is_referenced_by_AttributeAccess_set.add(inst);
    }
    @Override
    public void removeR788_is_referenced_by_AttributeAccess( AttributeAccess inst ) {
        R788_is_referenced_by_AttributeAccess_set.remove(inst);
    }
    @Override
    public AttributeAccessSet R788_is_referenced_by_AttributeAccess() throws XtumlException {
        return R788_is_referenced_by_AttributeAccess_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Attribute value() {
        return this;
    }

    @Override
    public Attribute self() {
        return this;
    }

    @Override
    public Attribute oneWhere( IWhere<Attribute> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ATTRIBUTE;
    }

}

class EmptyAttribute extends ModelInstance<Attribute,Sql> implements Attribute {

    // attributes
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBase_name( String m_base_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBase_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getOrder() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOrder( int m_order ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_name( String ref_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_package( String ref_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_reference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getIdentifier() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIdentifier( int m_identifier ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDefault_value() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDefault_value( String m_default_value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_initializer() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public WhereSet R3906_used_as_sort_field_for_Where() {
        return (new WhereSetImpl());
    }
    @Override
    public ModelInst R410_abstracts_data_for_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public O_ATTR R414_is_transformed_from_O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }
    @Override
    public TypeReference R424_is_typed_by_TypeReference() {
        return TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }
    @Override
    public AttributeReferenceSet R4506_has_value_provided_by_AttributeReference() {
        return (new AttributeReferenceSetImpl());
    }
    @Override
    public AttributeReferenceSet R4506_provides_value_for_AttributeReference() {
        return (new AttributeReferenceSetImpl());
    }
    @Override
    public AttributeAccessorSet R4510_value_accessed_through_AttributeAccessor() {
        return (new AttributeAccessorSetImpl());
    }
    @Override
    public AttributeAccessSet R788_is_referenced_by_AttributeAccess() {
        return (new AttributeAccessSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return AttributeImpl.KEY_LETTERS;
    }

    @Override
    public Attribute value() {
        return this;
    }
    
    @Override
    public Attribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Attribute oneWhere( IWhere<Attribute> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return AttributeImpl.EMPTY_ATTRIBUTE;
    }

}
