package io.ciera.tool.sql.architecture.application.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.application.ApplicationExecutor;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.application.impl.ApplicationExecutorImpl;
import io.ciera.tool.sql.architecture.application.impl.ApplicationImpl;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionImpl;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.interfaces.PortSet;

import java.util.Iterator;


public class ComponentInstantiationImpl extends ModelInstance<ComponentInstantiation,Sql> implements ComponentInstantiation {

    public static final String KEY_LETTERS = "ComponentInstantiation";
    public static final ComponentInstantiation EMPTY_COMPONENTINSTANTIATION = new EmptyComponentInstantiation();

    private Sql context;

    // constructors
    private ComponentInstantiationImpl( Sql context ) {
        this.context = context;
        ref_app_name = "";
        ref_app_package = "";
        ref_comp_name = "";
        ref_comp_package = "";
        ref_next_comp_name = "";
        ref_next_comp_package = "";
        m_index = 0;
        ref_executor_index = 0;
        m_instance_loading = "";
        m_simulated_time = false;
        R4028_is_executed_by_ApplicationExecutor_inst = ApplicationExecutorImpl.EMPTY_APPLICATIONEXECUTOR;
        R4029_follows_ComponentInstantiation_inst = ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
        R4029_precedes_ComponentInstantiation_inst = ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
        R426_is_broken_into_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R426_is_instantiated_by_Application_inst = ApplicationImpl.EMPTY_APPLICATION;
    }

    private ComponentInstantiationImpl( Sql context, UniqueId instanceId, String ref_app_name, String ref_app_package, String ref_comp_name, String ref_comp_package, String ref_next_comp_name, String ref_next_comp_package, int m_index, int ref_executor_index, String m_instance_loading, boolean m_simulated_time ) {
        super(instanceId);
        this.context = context;
        this.ref_app_name = ref_app_name;
        this.ref_app_package = ref_app_package;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        this.ref_next_comp_name = ref_next_comp_name;
        this.ref_next_comp_package = ref_next_comp_package;
        this.m_index = m_index;
        this.ref_executor_index = ref_executor_index;
        this.m_instance_loading = m_instance_loading;
        this.m_simulated_time = m_simulated_time;
        R4028_is_executed_by_ApplicationExecutor_inst = ApplicationExecutorImpl.EMPTY_APPLICATIONEXECUTOR;
        R4029_follows_ComponentInstantiation_inst = ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
        R4029_precedes_ComponentInstantiation_inst = ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
        R426_is_broken_into_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R426_is_instantiated_by_Application_inst = ApplicationImpl.EMPTY_APPLICATION;
    }

    public static ComponentInstantiation create( Sql context ) throws XtumlException {
        ComponentInstantiation newComponentInstantiation = new ComponentInstantiationImpl( context );
        if ( context.addInstance( newComponentInstantiation ) ) {
            newComponentInstantiation.getRunContext().addChange(new InstanceCreatedDelta(newComponentInstantiation, KEY_LETTERS));
            return newComponentInstantiation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ComponentInstantiation create( Sql context, UniqueId instanceId, String ref_app_name, String ref_app_package, String ref_comp_name, String ref_comp_package, String ref_next_comp_name, String ref_next_comp_package, int m_index, int ref_executor_index, String m_instance_loading, boolean m_simulated_time ) throws XtumlException {
        ComponentInstantiation newComponentInstantiation = new ComponentInstantiationImpl( context, instanceId, ref_app_name, ref_app_package, ref_comp_name, ref_comp_package, ref_next_comp_name, ref_next_comp_package, m_index, ref_executor_index, m_instance_loading, m_simulated_time );
        if ( context.addInstance( newComponentInstantiation ) ) {
            return newComponentInstantiation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_app_name;
    @Override
    public String getApp_name() throws XtumlException {
        checkLiving();
                return ref_app_name;
    }
    @Override
    public void setApp_name( String ref_app_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_app_name, this.ref_app_name ) ) {
            final String oldValue = this.ref_app_name;
            this.ref_app_name = ref_app_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_app_name", oldValue, this.ref_app_name));
            if ( !R4029_follows_ComponentInstantiation().isEmpty() ) R4029_follows_ComponentInstantiation().setApp_name( ref_app_name );
        }
    }
    private String ref_app_package;
    @Override
    public void setApp_package( String ref_app_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_app_package, this.ref_app_package ) ) {
            final String oldValue = this.ref_app_package;
            this.ref_app_package = ref_app_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_app_package", oldValue, this.ref_app_package));
            if ( !R4029_follows_ComponentInstantiation().isEmpty() ) R4029_follows_ComponentInstantiation().setApp_package( ref_app_package );
        }
    }
    @Override
    public String getApp_package() throws XtumlException {
        checkLiving();
                return ref_app_package;
    }
    private String ref_comp_name;
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_name, this.ref_comp_name ) ) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
            if ( !R4029_follows_ComponentInstantiation().isEmpty() ) R4029_follows_ComponentInstantiation().setNext_comp_name( ref_comp_name );
        }
    }
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
                return ref_comp_name;
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
                return ref_comp_package;
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_package, this.ref_comp_package ) ) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
            if ( !R4029_follows_ComponentInstantiation().isEmpty() ) R4029_follows_ComponentInstantiation().setNext_comp_package( ref_comp_package );
        }
    }
    private String ref_next_comp_name;
    @Override
    public void setNext_comp_name( String ref_next_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_next_comp_name, this.ref_next_comp_name ) ) {
            final String oldValue = this.ref_next_comp_name;
            this.ref_next_comp_name = ref_next_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_next_comp_name", oldValue, this.ref_next_comp_name));
        }
    }
    @Override
    public String getNext_comp_name() throws XtumlException {
        checkLiving();
                return ref_next_comp_name;
    }
    private String ref_next_comp_package;
    @Override
    public String getNext_comp_package() throws XtumlException {
        checkLiving();
                return ref_next_comp_package;
    }
    @Override
    public void setNext_comp_package( String ref_next_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_next_comp_package, this.ref_next_comp_package ) ) {
            final String oldValue = this.ref_next_comp_package;
            this.ref_next_comp_package = ref_next_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_next_comp_package", oldValue, this.ref_next_comp_package));
        }
    }
    private int m_index;
    @Override
    public void setIndex( int m_index ) throws XtumlException {
        checkLiving();
        if ( m_index != this.m_index ) {
            final int oldValue = this.m_index;
            this.m_index = m_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_index", oldValue, this.m_index));
        }
    }
    @Override
    public int getIndex() throws XtumlException {
        checkLiving();
                return m_index;
    }
    private int ref_executor_index;
    @Override
    public int getExecutor_index() throws XtumlException {
        checkLiving();
                return ref_executor_index;
    }
    @Override
    public void setExecutor_index( int ref_executor_index ) throws XtumlException {
        checkLiving();
        if ( ref_executor_index != this.ref_executor_index ) {
            final int oldValue = this.ref_executor_index;
            this.ref_executor_index = ref_executor_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_executor_index", oldValue, this.ref_executor_index));
        }
    }
    private String m_instance_loading;
    @Override
    public void setInstance_loading( String m_instance_loading ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_instance_loading, this.m_instance_loading ) ) {
            final String oldValue = this.m_instance_loading;
            this.m_instance_loading = m_instance_loading;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_instance_loading", oldValue, this.m_instance_loading));
        }
    }
    @Override
    public String getInstance_loading() throws XtumlException {
        checkLiving();
                return m_instance_loading;
    }
    private boolean m_simulated_time;
    @Override
    public boolean getSimulated_time() throws XtumlException {
        checkLiving();
                return m_simulated_time;
    }
    @Override
    public void setSimulated_time( boolean m_simulated_time ) throws XtumlException {
        checkLiving();
        if ( m_simulated_time != this.m_simulated_time ) {
            final boolean oldValue = this.m_simulated_time;
            this.m_simulated_time = m_simulated_time;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_simulated_time", oldValue, this.m_simulated_time));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getApp_name(), getApp_package(), getComp_name(), getComp_package());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "application/t.componentinstantiation.java", self() );
    }

    @Override
    public void render_satisfactions() throws XtumlException {
        PortSet requirements = self().R426_is_broken_into_ComponentDefinition().R417_communicates_through_Port().where( selected -> !selected.getProvider() );
        Port requirement;
        for ( Iterator<Port> _requirement_iter = requirements.elements().iterator(); _requirement_iter.hasNext(); ) {
            requirement = _requirement_iter.next();
            String req_comp_name = requirement.getComp_name();
            int req_comp_index = self().getIndex();
            String req_port_name = requirement.getPort_name();
            Port provision = requirement.R4160_satisfies_provided_Port();
            ComponentInstantiation prov_comp_inst = provision.R417_passes_messages_for_ComponentDefinition().R426_is_instantiated_by_ComponentInstantiation().any();
            if ( !provision.isEmpty() && !prov_comp_inst.isEmpty() ) {
                String prov_comp_name = provision.getComp_name();
                int prov_comp_index = prov_comp_inst.getIndex();
                String prov_port_name = provision.getPort_name();
                context().T().include( "application/t.satisfaction.java", prov_comp_index, prov_comp_name, prov_port_name, req_comp_index, req_comp_name, req_port_name );
            }
        }
    }



    // static operations


    // events


    // selections
    private ApplicationExecutor R4028_is_executed_by_ApplicationExecutor_inst;
    @Override
    public void setR4028_is_executed_by_ApplicationExecutor( ApplicationExecutor inst ) {
        R4028_is_executed_by_ApplicationExecutor_inst = inst;
    }
    @Override
    public ApplicationExecutor R4028_is_executed_by_ApplicationExecutor() throws XtumlException {
        return R4028_is_executed_by_ApplicationExecutor_inst;
    }
    private ComponentInstantiation R4029_follows_ComponentInstantiation_inst;
    @Override
    public void setR4029_follows_ComponentInstantiation( ComponentInstantiation inst ) {
        R4029_follows_ComponentInstantiation_inst = inst;
    }
    @Override
    public ComponentInstantiation R4029_follows_ComponentInstantiation() throws XtumlException {
        return R4029_follows_ComponentInstantiation_inst;
    }
    private ComponentInstantiation R4029_precedes_ComponentInstantiation_inst;
    @Override
    public void setR4029_precedes_ComponentInstantiation( ComponentInstantiation inst ) {
        R4029_precedes_ComponentInstantiation_inst = inst;
    }
    @Override
    public ComponentInstantiation R4029_precedes_ComponentInstantiation() throws XtumlException {
        return R4029_precedes_ComponentInstantiation_inst;
    }
    private ComponentDefinition R426_is_broken_into_ComponentDefinition_inst;
    @Override
    public void setR426_is_broken_into_ComponentDefinition( ComponentDefinition inst ) {
        R426_is_broken_into_ComponentDefinition_inst = inst;
    }
    @Override
    public ComponentDefinition R426_is_broken_into_ComponentDefinition() throws XtumlException {
        return R426_is_broken_into_ComponentDefinition_inst;
    }
    private Application R426_is_instantiated_by_Application_inst;
    @Override
    public void setR426_is_instantiated_by_Application( Application inst ) {
        R426_is_instantiated_by_Application_inst = inst;
    }
    @Override
    public Application R426_is_instantiated_by_Application() throws XtumlException {
        return R426_is_instantiated_by_Application_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ComponentInstantiation value() {
        return this;
    }

    @Override
    public ComponentInstantiation self() {
        return this;
    }

    @Override
    public ComponentInstantiation oneWhere( IWhere<ComponentInstantiation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_COMPONENTINSTANTIATION;
    }

}

class EmptyComponentInstantiation extends ModelInstance<ComponentInstantiation,Sql> implements ComponentInstantiation {

    // attributes
    public String getApp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setApp_name( String ref_app_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setApp_package( String ref_app_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getApp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setNext_comp_name( String ref_next_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getNext_comp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getNext_comp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNext_comp_package( String ref_next_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIndex( int m_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getIndex() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getExecutor_index() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExecutor_index( int ref_executor_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInstance_loading( String m_instance_loading ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInstance_loading() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getSimulated_time() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSimulated_time( boolean m_simulated_time ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_satisfactions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ApplicationExecutor R4028_is_executed_by_ApplicationExecutor() {
        return ApplicationExecutorImpl.EMPTY_APPLICATIONEXECUTOR;
    }
    @Override
    public ComponentInstantiation R4029_follows_ComponentInstantiation() {
        return ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
    }
    @Override
    public ComponentInstantiation R4029_precedes_ComponentInstantiation() {
        return ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
    }
    @Override
    public ComponentDefinition R426_is_broken_into_ComponentDefinition() {
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }
    @Override
    public Application R426_is_instantiated_by_Application() {
        return ApplicationImpl.EMPTY_APPLICATION;
    }


    @Override
    public String getKeyLetters() {
        return ComponentInstantiationImpl.KEY_LETTERS;
    }

    @Override
    public ComponentInstantiation value() {
        return this;
    }
    
    @Override
    public ComponentInstantiation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ComponentInstantiation oneWhere( IWhere<ComponentInstantiation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
    }

}
