package io.ciera.tool.sql.architecture.application.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.application.ApplicationExecutor;
import io.ciera.tool.sql.architecture.application.ApplicationExecutorSet;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.application.impl.ApplicationExecutorSetImpl;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationSetImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;

import java.util.Iterator;

import types.ImportType;


public class ApplicationImpl extends ModelInstance<Application,Sql> implements Application {

    public static final String KEY_LETTERS = "Application";
    public static final Application EMPTY_APPLICATION = new EmptyApplication();

    private Sql context;

    // constructors
    private ApplicationImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        m_async = false;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R4027_delegates_execution_to_ApplicationExecutor_set = new ApplicationExecutorSetImpl();
        R426_is_broken_into_ComponentInstantiation_set = new ComponentInstantiationSetImpl();
    }

    private ApplicationImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, boolean m_async ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.m_async = m_async;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R4027_delegates_execution_to_ApplicationExecutor_set = new ApplicationExecutorSetImpl();
        R426_is_broken_into_ComponentInstantiation_set = new ComponentInstantiationSetImpl();
    }

    public static Application create( Sql context ) throws XtumlException {
        Application newApplication = new ApplicationImpl( context );
        if ( context.addInstance( newApplication ) ) {
            newApplication.getRunContext().addChange(new InstanceCreatedDelta(newApplication, KEY_LETTERS));
            return newApplication;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Application create( Sql context, UniqueId instanceId, String ref_name, String ref_package, boolean m_async ) throws XtumlException {
        Application newApplication = new ApplicationImpl( context, instanceId, ref_name, ref_package, m_async );
        if ( context.addInstance( newApplication ) ) {
            return newApplication;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R4027_delegates_execution_to_ApplicationExecutor().isEmpty() ) R4027_delegates_execution_to_ApplicationExecutor().setApp_name( ref_name );
            if ( !R426_is_broken_into_ComponentInstantiation().isEmpty() ) R426_is_broken_into_ComponentInstantiation().setApp_name( ref_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
                return ref_package;
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_package, this.ref_package ) ) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R426_is_broken_into_ComponentInstantiation().isEmpty() ) R426_is_broken_into_ComponentInstantiation().setApp_package( ref_package );
            if ( !R4027_delegates_execution_to_ApplicationExecutor().isEmpty() ) R4027_delegates_execution_to_ApplicationExecutor().setApp_package( ref_package );
        }
    }
    private boolean m_async;
    @Override
    public boolean getAsync() throws XtumlException {
        checkLiving();
                return m_async;
    }
    @Override
    public void setAsync( boolean m_async ) throws XtumlException {
        checkLiving();
        if ( m_async != this.m_async ) {
            final boolean oldValue = this.m_async;
            this.m_async = m_async;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_async", oldValue, this.m_async));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        String imports = file.getFormattedImports( ImportType.IMPL );
        ComponentInstantiationSet comps = self().R426_is_broken_into_ComponentInstantiation();
        ComponentInstantiation comp;
        for ( Iterator<ComponentInstantiation> _comp_iter = comps.elements().iterator(); _comp_iter.hasNext(); ) {
            comp = _comp_iter.next();
            comp.render();
        }
        String component_instantiations = context().T().body();
        context().T().clear();
        for ( Iterator<ComponentInstantiation> _comp_iter = comps.elements().iterator(); _comp_iter.hasNext(); ) {
            comp = _comp_iter.next();
            comp.render_satisfactions();
        }
        String component_satisfactions = context().T().body();
        context().T().clear();
        int num_component_instances = comps.size();
        ApplicationExecutorSet executors = self().R4027_delegates_execution_to_ApplicationExecutor();
        int num_executors = executors.size();
        if ( self().getAsync() ) {
            context().T().include( "application/t.application.async.java", component_instantiations, component_satisfactions, imports, num_component_instances, self() );
        }
        else {
            context().T().include( "application/t.application.java", component_instantiations, component_satisfactions, imports, num_component_instances, num_executors, self() );
        }
        context().T().emit( ( ( file.getPath() + "/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }



    // static operations


    // events


    // selections
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }
    private ApplicationExecutorSet R4027_delegates_execution_to_ApplicationExecutor_set;
    @Override
    public void addR4027_delegates_execution_to_ApplicationExecutor( ApplicationExecutor inst ) {
        R4027_delegates_execution_to_ApplicationExecutor_set.add(inst);
    }
    @Override
    public void removeR4027_delegates_execution_to_ApplicationExecutor( ApplicationExecutor inst ) {
        R4027_delegates_execution_to_ApplicationExecutor_set.remove(inst);
    }
    @Override
    public ApplicationExecutorSet R4027_delegates_execution_to_ApplicationExecutor() throws XtumlException {
        return R4027_delegates_execution_to_ApplicationExecutor_set;
    }
    private ComponentInstantiationSet R426_is_broken_into_ComponentInstantiation_set;
    @Override
    public void addR426_is_broken_into_ComponentInstantiation( ComponentInstantiation inst ) {
        R426_is_broken_into_ComponentInstantiation_set.add(inst);
    }
    @Override
    public void removeR426_is_broken_into_ComponentInstantiation( ComponentInstantiation inst ) {
        R426_is_broken_into_ComponentInstantiation_set.remove(inst);
    }
    @Override
    public ComponentInstantiationSet R426_is_broken_into_ComponentInstantiation() throws XtumlException {
        return R426_is_broken_into_ComponentInstantiation_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Application value() {
        return this;
    }

    @Override
    public Application self() {
        return this;
    }

    @Override
    public Application oneWhere( IWhere<Application> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_APPLICATION;
    }

}

class EmptyApplication extends ModelInstance<Application,Sql> implements Application {

    // attributes
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getAsync() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAsync( boolean m_async ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public ApplicationExecutorSet R4027_delegates_execution_to_ApplicationExecutor() {
        return (new ApplicationExecutorSetImpl());
    }
    @Override
    public ComponentInstantiationSet R426_is_broken_into_ComponentInstantiation() {
        return (new ComponentInstantiationSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ApplicationImpl.KEY_LETTERS;
    }

    @Override
    public Application value() {
        return this;
    }
    
    @Override
    public Application self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Application oneWhere( IWhere<Application> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ApplicationImpl.EMPTY_APPLICATION;
    }

}
