/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.types;

import io.ciera.runtime.api.exceptions.DeserializationException;
import java.io.Serializable;
import java.util.UUID;

public class UniqueId
implements Comparable<UniqueId>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final UniqueId ZERO = new UniqueId();
    private static long lastId = 0L;
    private UUID id;

    public UniqueId() {
        this.id = new UUID(0L, 0L);
    }

    public UniqueId(UUID id) {
        this.id = id;
    }

    public UniqueId(long id) {
        this.id = new UUID(0L, id);
    }

    public UniqueId(UniqueId id) {
        this.id = id.id;
    }

    public static UniqueId random() {
        if (System.getProperty("io.ciera.runtime.useDeterministicIDs") != null) {
            return new UniqueId(++lastId);
        }
        return new UniqueId(UUID.randomUUID());
    }

    @Override
    public int compareTo(UniqueId o) {
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object o) {
        return o instanceof UniqueId && this.id.equals(((UniqueId)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        if (System.getProperty("io.ciera.runtime.useDeterministicIDs") != null) {
            return Long.toString(this.id.getLeastSignificantBits());
        }
        return this.id.toString();
    }

    public static UniqueId fromString(String s) {
        try {
            return new UniqueId(UUID.fromString(s));
        }
        catch (IllegalArgumentException e) {
            throw new DeserializationException("Could not parse UniqueId", e);
        }
    }
}

