/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.types;

import io.ciera.runtime.api.exceptions.DeserializationException;
import io.ciera.runtime.api.time.SystemClock;
import io.ciera.runtime.api.types.TimeStamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.TimeZone;

public class Date
extends TimeStamp {
    private static final long serialVersionUID = 1L;
    public static final Date ZERO = new Date();
    private static final DateTimeFormatter SERIALIZE_FORMAT = DateTimeFormatter.ISO_INSTANT;
    private static final DateTimeFormatter[] PARSE_FORMATS = new DateTimeFormatter[]{DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME};
    private final Calendar cal = Calendar.getInstance();

    public Date() {
        this(0L, Instant.EPOCH);
    }

    public Date(long timestamp) {
        this(timestamp, Instant.EPOCH);
    }

    public Date(TimeStamp o) {
        this(o.getValue());
    }

    public Date(long timestamp, Instant epoch) {
        super(timestamp);
        this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.cal.setTimeInMillis(timestamp / 1000000L - epoch.until(Instant.EPOCH, ChronoUnit.MILLIS));
    }

    public int getYear() {
        return this.cal.get(1);
    }

    public int getMonth() {
        return this.cal.get(2) + 1;
    }

    public int getDay() {
        return this.cal.get(5);
    }

    public int getHour() {
        return this.cal.get(11);
    }

    public int getMinute() {
        return this.cal.get(12);
    }

    public int getSecond() {
        return this.cal.get(13);
    }

    public static Date now(SystemClock clock) {
        return new Date(clock.getTime(), clock.getEpoch());
    }

    @Override
    public String toString() {
        return SERIALIZE_FORMAT.format(this.cal.toInstant());
    }

    public static Date fromString(String s) {
        DeserializationException err = null;
        for (DateTimeFormatter format : PARSE_FORMATS) {
            try {
                TemporalAccessor t = format.parse(s);
                return new Date(t.getLong(ChronoField.INSTANT_SECONDS) * 1000000000L + t.getLong(ChronoField.NANO_OF_SECOND));
            }
            catch (NullPointerException | DateTimeParseException e) {
                err = new DeserializationException("Could not parse date", e);
            }
        }
        throw err;
    }
}

