/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.exceptions;

import io.ciera.runtime.api.domain.InstancePopulation;
import io.ciera.runtime.api.domain.ObjectInstance;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InstancePopulationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final InstancePopulation population;
    private final ObjectInstance[] instances;

    public InstancePopulationException(String message, InstancePopulation population, ObjectInstance ... instances) {
        this(message, null, population, instances);
    }

    public InstancePopulationException(String message, Throwable cause, InstancePopulation population, ObjectInstance ... instances) {
        super(message, cause);
        this.population = population;
        this.instances = instances;
    }

    public InstancePopulation getPopulation() {
        return this.population;
    }

    public ObjectInstance[] getInstances() {
        return this.instances;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + ": [population=" + this.population + ", instances=[" + Stream.of(this.instances).map(inst -> inst.toString()).collect(Collectors.joining(", ")) + "]]";
    }
}

