/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.domain;

import io.ciera.runtime.api.action.ActionHome;
import io.ciera.runtime.api.application.Event;
import io.ciera.runtime.api.application.EventTarget;
import io.ciera.runtime.api.domain.TransitionRule;
import io.ciera.runtime.api.exceptions.CannotHappenException;

public interface StateMachine
extends ActionHome,
EventTarget {
    public Enum<?> getCurrentState();

    public TransitionRule getTransition(Enum<?> var1, Event var2);

    default public TransitionRule cannotHappen(Enum<?> currentState, Event event) {
        return () -> {
            this.traceTxn("TXN END:", this.toString(), currentState.name(), event.toString(), "CANNOT HAPPEN", "\u001b[31m");
            throw new CannotHappenException();
        };
    }

    default public TransitionRule ignore(Enum<?> currentState, Event event) {
        return () -> {
            this.traceTxn("TXN END:", this.toString(), currentState.name(), event.toString(), "IGNORE", "\u001b[33m");
            return null;
        };
    }

    default public void traceTxn(String txnType, String targetName, String currentState, String eventName, String nextState, String nextStateColor) {
        this.getApplication().getLogger().trace("%-15s %-35s: %-50s %-50s => %-40s", txnType, targetName, "\u001b[36m" + currentState + "\u001b[0m", "[ " + eventName + " ]", nextStateColor + nextState + "\u001b[0m");
    }
}

