/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.application;

import io.ciera.runtime.api.application.ExceptionHandler;
import io.ciera.runtime.api.application.ExecutionContext;
import io.ciera.runtime.api.application.Logger;
import io.ciera.runtime.api.domain.Domain;
import io.ciera.runtime.api.time.SystemClock;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public interface Application {
    public String getName();

    public SystemClock getClock();

    public void setClock(SystemClock var1);

    public void setup();

    public void initialize();

    public void start();

    public void stop();

    public Collection<? extends ExecutionContext> getContexts();

    public <T extends ExecutionContext> T getContext(String var1);

    public ExecutionContext defaultContext();

    public void addContext(ExecutionContext var1);

    public Collection<Domain> getDomains();

    public Domain getDomain(String var1);

    public void addDomain(Domain var1);

    public Stream<Domain> findDomains(String ... var1);

    public Logger getLogger();

    public void setLogger(Logger var1);

    public ExceptionHandler getExceptionHandler();

    public void setExceptionHandler(ExceptionHandler var1);

    public boolean isRunning();

    public static Application getInstance(String name) {
        return ServiceLoader.load(Application.class).stream().map(ServiceLoader.Provider::get).filter(app -> app.getName().equals(name)).findAny().orElseThrow();
    }

    public static Application getInstance() {
        return ServiceLoader.load(Application.class).findFirst().orElseThrow();
    }
}

