/*
 * Decompiled with CFR 0.152.
 */
package io.chucknorris.client;

import io.chucknorris.client.ChuckNorrisException;
import io.chucknorris.client.Joke;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ChuckNorrisClient {
    public static final String BASE_URL = "https://api.chucknorris.io/jokes";

    public List<String> getCategories() {
        try {
            HttpURLConnection conn = this.createConnection("https://api.chucknorris.io/jokes/categories");
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                ArrayList<String> categories = new ArrayList<String>();
                JSONArray jsonArray = new JSONArray(new JSONTokener(conn.getInputStream()));
                for (int i = 0; i < jsonArray.length(); ++i) {
                    categories.add(jsonArray.getString(i));
                }
                return categories;
            }
            ChuckNorrisException e = this.createException(conn);
            throw e;
        }
        catch (IOException e) {
            throw new ChuckNorrisException("Error retrieving categories", e);
        }
    }

    public Joke getRandomJoke() {
        return this.getRandomJoke(null);
    }

    public Joke getRandomJoke(String category) {
        try {
            HttpURLConnection conn;
            int respCode;
            StringBuilder url = new StringBuilder("https://api.chucknorris.io/jokes/random");
            if (category != null && category.length() > 0) {
                url.append("?category=").append(this.urlEncode(category));
            }
            if ((respCode = (conn = this.createConnection(url.toString())).getResponseCode()) == 200) {
                JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getInputStream()));
                return this.parseJoke(jsonObject);
            }
            ChuckNorrisException e = this.createException(conn);
            throw e;
        }
        catch (IOException e) {
            throw new ChuckNorrisException("Error retrieving random joke", e);
        }
    }

    public List<Joke> searchJokes(String query) {
        try {
            StringBuilder url = new StringBuilder("https://api.chucknorris.io/jokes/search");
            url.append("?query=").append(this.urlEncode(query));
            HttpURLConnection conn = this.createConnection(url.toString());
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                ArrayList<Joke> jokes = new ArrayList<Joke>();
                JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getInputStream()));
                if (jsonObject.getInt("total") > 0) {
                    JSONArray jsonResult = jsonObject.getJSONArray("result");
                    for (int i = 0; i < jsonResult.length(); ++i) {
                        JSONObject jsonJoke = jsonResult.getJSONObject(i);
                        jokes.add(this.parseJoke(jsonJoke));
                    }
                }
                return jokes;
            }
            ChuckNorrisException e = this.createException(conn);
            throw e;
        }
        catch (IOException e) {
            throw new ChuckNorrisException("Error searching jokes", e);
        }
    }

    private String getVersion() {
        Package pkg = ChuckNorrisClient.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ChuckNorrisException("Unable to url encode string: " + s, e);
        }
    }

    private HttpURLConnection createConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("User-Agent", "chucknorris-io/client-java-" + this.getVersion());
        return conn;
    }

    private ChuckNorrisException createException(HttpURLConnection conn) throws IOException {
        JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getErrorStream()));
        String message = jsonObject.optString("message");
        return new ChuckNorrisException(message);
    }

    private Joke parseJoke(JSONObject jsonObject) {
        Joke joke = new Joke();
        joke.setId(jsonObject.optString("id"));
        joke.setValue(jsonObject.optString("value"));
        joke.setSourceUrl(jsonObject.optString("url"));
        joke.setIconUrl(jsonObject.optString("icon_url"));
        JSONArray jsonCategories = jsonObject.optJSONArray("category");
        if (jsonCategories != null) {
            for (int i = 0; i < jsonCategories.length(); ++i) {
                joke.addCategory(jsonCategories.getString(i));
            }
        }
        return joke;
    }
}

