/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.niochar.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class ISO_8859_1
extends Charset {
    public ISO_8859_1(String csName, String[] aliases) {
        super(csName, aliases);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof ISO_8859_1;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private final class Encoder
    extends CharsetEncoder {
        private Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        private native void nEncode(long var1, int var3, char[] var4, int var5, int[] var6);

        @Override
        protected CoderResult encodeLoop(CharBuffer cb, ByteBuffer bb) {
            int cbRemaining = cb.remaining();
            if (cbRemaining == 0) {
                return CoderResult.UNDERFLOW;
            }
            int bbRemaining = bb.remaining();
            boolean cbHasArray = cb.hasArray();
            boolean bbHasArray = bb.hasArray();
            if (cbHasArray && bbHasArray) {
                int x;
                byte[] byteArr = bb.array();
                char[] charArr = cb.array();
                int byteArrStart = bb.position();
                int rem = bbRemaining <= cbRemaining ? bbRemaining : cbRemaining;
                int cbPos = cb.position();
                char jchar = '\u0000';
                for (x = cbPos; x < cbPos + rem && (jchar = charArr[x]) <= '\u00ff'; ++x) {
                    byteArr[byteArrStart++] = (byte)jchar;
                }
                bb.position(byteArrStart);
                cb.position(x);
                if (x == cbPos + rem) {
                    if (rem == bbRemaining && cb.hasRemaining()) {
                        return CoderResult.OVERFLOW;
                    }
                    return CoderResult.UNDERFLOW;
                }
                if (jchar >= '\ud800' && jchar <= '\udfff') {
                    if (x + 1 < cb.limit()) {
                        char c1 = charArr[x + 1];
                        if (c1 >= '\ud800' && c1 <= '\udfff') {
                            return CoderResult.unmappableForLength(2);
                        }
                    } else {
                        return CoderResult.UNDERFLOW;
                    }
                    return CoderResult.malformedForLength(1);
                }
                return CoderResult.unmappableForLength(1);
            }
            while (cb.hasRemaining()) {
                if (bbRemaining == 0) {
                    return CoderResult.OVERFLOW;
                }
                char c = cb.get();
                if (c > '\u00ff') {
                    if (c >= '\ud800' && c <= '\udfff') {
                        if (cb.hasRemaining()) {
                            char c1 = cb.get();
                            if (c1 >= '\ud800' && c1 <= '\udfff') {
                                cb.position(cb.position() - 2);
                                return CoderResult.unmappableForLength(2);
                            }
                        } else {
                            cb.position(cb.position() - 1);
                            return CoderResult.UNDERFLOW;
                        }
                        cb.position(cb.position() - 1);
                        cb.position(cb.position() - 1);
                        return CoderResult.malformedForLength(1);
                    }
                    cb.position(cb.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                bb.put((byte)c);
                --bbRemaining;
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private final class Decoder
    extends CharsetDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        private native int nDecode(char[] var1, int var2, int var3, long var4, int var6);

        @Override
        protected CoderResult decodeLoop(ByteBuffer bb, CharBuffer cb) {
            int bbRemaining = bb.remaining();
            if (bbRemaining == 0) {
                return CoderResult.UNDERFLOW;
            }
            int cbRemaining = cb.remaining();
            boolean cbHasArray = cb.hasArray();
            if (cbHasArray && bb.hasArray()) {
                int i;
                int rem = bbRemaining;
                rem = cbRemaining >= rem ? rem : cbRemaining;
                byte[] arr = bb.array();
                char[] cArr = cb.array();
                int bStart = bb.position();
                int cStart = cb.position();
                for (i = bStart; i < bStart + rem; ++i) {
                    cArr[cStart++] = (char)(arr[i] & 0xFF);
                }
                bb.position(i);
                cb.position(cStart);
                if (rem == cbRemaining && bb.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                return CoderResult.UNDERFLOW;
            }
            int rem = bbRemaining;
            rem = cbRemaining >= rem ? rem : cbRemaining;
            byte[] arr = new byte[rem];
            bb.get(arr);
            char[] cArr = new char[rem];
            for (int i = 0; i < rem; ++i) {
                cArr[i] = (char)(arr[i] & 0xFF);
            }
            cb.put(cArr);
            if (cb.remaining() == 0) {
                return CoderResult.OVERFLOW;
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

