/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;

class SerializedForm
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Class<?> messageClass;
    private final byte[] asBytes;

    public static SerializedForm of(MessageLite message) {
        return new SerializedForm(message);
    }

    SerializedForm(MessageLite regularForm) {
        this.messageClass = regularForm.getClass();
        this.asBytes = regularForm.toByteArray();
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            Class<?> messageClass = this.resolveMessageClass();
            Field defaultInstanceField = messageClass.getDeclaredField("DEFAULT_INSTANCE");
            defaultInstanceField.setAccessible(true);
            MessageLite defaultInstance = (MessageLite)defaultInstanceField.get(null);
            return defaultInstance.newBuilderForType().mergeFrom(this.asBytes).buildPartial();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find proto buffer class", e);
        }
        catch (NoSuchFieldException e) {
            return this.readResolveFallback();
        }
        catch (SecurityException e) {
            throw new RuntimeException("Unable to call DEFAULT_INSTANCE in (class)", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to call parsePartialFrom", e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unable to understand proto buffer", e);
        }
    }

    @Deprecated
    private Object readResolveFallback() throws ObjectStreamException {
        try {
            Class<?> messageClass = this.resolveMessageClass();
            Field defaultInstanceField = messageClass.getDeclaredField("defaultInstance");
            defaultInstanceField.setAccessible(true);
            MessageLite defaultInstance = (MessageLite)defaultInstanceField.get(null);
            return defaultInstance.newBuilderForType().mergeFrom(this.asBytes).buildPartial();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find proto buffer class", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to find defaultInstance in (class)", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Unable to call defaultInstance in (class)", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to call parsePartialFrom", e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unable to understand proto buffer", e);
        }
    }

    private Class<?> resolveMessageClass() throws ClassNotFoundException {
        return this.messageClass;
    }
}

