/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.platform.test;

import io.cettia.platform.action.Action;
import io.cettia.platform.action.VoidAction;
import io.cettia.platform.websocket.ServerWebSocket;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class ServerWebSocketTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)10L);
    protected Performer performer;
    protected int port;

    @Before
    public void before() throws Exception {
        this.performer = new Performer();
        try (ServerSocket serverSocket = new ServerSocket(0);){
            this.port = serverSocket.getLocalPort();
        }
        this.startServer();
    }

    @After
    public void after() throws Exception {
        this.stopServer();
    }

    protected abstract void startServer() throws Exception;

    protected abstract void stopServer() throws Exception;

    @Test
    public void uri() {
        this.performer.onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                Assert.assertThat((Object)ws.uri(), (Matcher)Matchers.is((Object)"/test?hello=there"));
                ServerWebSocketTest.this.performer.start();
            }
        }).connect("/test?hello=there");
    }

    @Test
    public void close() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketClose(int statusCode, String reason) {
                ServerWebSocketTest.this.performer.start();
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.close();
            }
        }).connect();
    }

    @Test
    public void close_idempotent() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketClose(int statusCode, String reason) {
                ServerWebSocketTest.this.performer.start();
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.close();
                ws.close();
            }
        }).connect();
    }

    @Test
    public void send_text() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketText(String message) {
                Assert.assertThat((Object)message, (Matcher)Matchers.is((Object)"A Will Remains in the Ashes"));
                ServerWebSocketTest.this.performer.start();
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send("A Will Remains in the Ashes");
            }
        }).connect();
    }

    @Test
    public void send_binary() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketBinary(byte[] payload, int offset, int len) {
                Assert.assertThat((Object)payload, (Matcher)Matchers.is((Object)new byte[]{0, 1, 2}));
                ServerWebSocketTest.this.performer.start();
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send(ByteBuffer.wrap(new byte[]{0, 1, 2}).asReadOnlyBuffer());
            }
        }).connect();
    }

    @Test
    public void send_text_and_binary() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){
            boolean done;

            public void onWebSocketText(String message) {
                Assert.assertThat((Object)message, (Matcher)Matchers.is((Object)"A Will Remains in the Ashes"));
                if (this.done) {
                    ServerWebSocketTest.this.performer.start();
                } else {
                    this.done = true;
                }
            }

            public void onWebSocketBinary(byte[] payload, int offset, int len) {
                Assert.assertThat((Object)payload, (Matcher)Matchers.is((Object)new byte[]{0, 1, 2}));
                if (this.done) {
                    ServerWebSocketTest.this.performer.start();
                } else {
                    this.done = true;
                }
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send("A Will Remains in the Ashes").send(ByteBuffer.wrap(new byte[]{0, 1, 2}));
            }
        }).connect();
    }

    @Test
    public void ontext() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.getRemote().sendString("A road of winds the water builds", new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.ontext((Action)new Action<String>(){

                    public void on(String data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)"A road of winds the water builds"));
                        ServerWebSocketTest.this.performer.start();
                    }
                });
            }
        }).connect();
    }

    @Test
    public void onbinary() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.getRemote().sendBytes(ByteBuffer.wrap(new byte[]{0, 1, 2}), new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.onbinary((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)ByteBuffer.wrap(new byte[]{0, 1, 2})));
                        ServerWebSocketTest.this.performer.start();
                    }
                });
            }
        }).connect();
    }

    @Test
    public void ontext_and_onbinary() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.getRemote().sendString("A road of winds the water builds", new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
                sess.getRemote().sendBytes(ByteBuffer.wrap(new byte[]{0, 1, 2}), new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
            }
        }).onserver(new Action<ServerWebSocket>(){
            boolean done;

            public void on(ServerWebSocket ws) {
                ws.ontext((Action)new Action<String>(){

                    public void on(String data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)"A road of winds the water builds"));
                        if (done) {
                            ServerWebSocketTest.this.performer.start();
                        } else {
                            done = true;
                        }
                    }
                }).onbinary((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)ByteBuffer.wrap(new byte[]{0, 1, 2})));
                        if (done) {
                            ServerWebSocketTest.this.performer.start();
                        } else {
                            done = true;
                        }
                    }
                });
            }
        }).connect();
    }

    @Test
    public void onclose_by_server() {
        this.performer.onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.onclose((Action)new VoidAction(){

                    public void on() {
                        ServerWebSocketTest.this.performer.start();
                    }
                }).close();
            }
        }).connect();
    }

    @Test
    public void onclose_by_client() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.close();
            }
        }).onserver(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.onclose((Action)new VoidAction(){

                    public void on() {
                        ServerWebSocketTest.this.performer.start();
                    }
                });
            }
        }).connect();
    }

    protected class Performer {
        CountDownLatch latch = new CountDownLatch(1);
        WebSocketListener clientListener = new WebSocketAdapter();
        Action<ServerWebSocket> serverAction = new Action<ServerWebSocket>(){

            public void on(ServerWebSocket object) {
            }
        };

        protected Performer() {
        }

        public Performer clientListener(WebSocketListener clientListener) {
            this.clientListener = clientListener;
            return this;
        }

        public Action<ServerWebSocket> serverAction() {
            return new Action<ServerWebSocket>(){

                public void on(ServerWebSocket ws) {
                    Performer.this.serverAction.on((Object)ws);
                }
            };
        }

        public Performer onserver(Action<ServerWebSocket> serverAction) {
            this.serverAction = serverAction;
            return this;
        }

        public Performer connect() {
            return this.connect("/test");
        }

        public Performer connect(String uri) {
            WebSocketClient client = new WebSocketClient();
            try {
                client.start();
                client.connect((Object)this.clientListener, URI.create("ws://localhost:" + ServerWebSocketTest.this.port + uri));
                this.latch.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    client.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        public Performer start() {
            this.latch.countDown();
            return this;
        }
    }
}

