/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.platform.test;

import io.cettia.platform.action.Action;
import io.cettia.platform.action.VoidAction;
import io.cettia.platform.http.HttpStatus;
import io.cettia.platform.http.ServerHttpExchange;
import java.io.ByteArrayOutputStream;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class ServerHttpExchangeTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)10L);
    protected Performer performer;
    protected int port;

    @Before
    public void before() throws Exception {
        this.performer = new Performer();
        try (ServerSocket serverSocket = new ServerSocket(0);){
            this.port = serverSocket.getLocalPort();
        }
        this.startServer();
    }

    @After
    public void after() throws Exception {
        this.stopServer();
    }

    protected abstract void startServer() throws Exception;

    protected abstract void stopServer() throws Exception;

    @Test
    public void uri() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                Assert.assertThat((Object)http.uri(), (Matcher)Matchers.is((Object)"/test?hello=there"));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).send("/test?hello=there");
    }

    @Test
    public void method() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                Assert.assertThat((Object)http.method(), (Matcher)Matchers.is((Object)"POST"));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST);
            }
        }).send();
    }

    @Test
    public void header() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                Assert.assertThat((Object)http.headerNames(), (Matcher)Matchers.either((Matcher)Matchers.hasItems((Object[])new String[]{"a", "b"})).or(Matchers.hasItems((Object[])new String[]{"A", "B"})));
                Assert.assertThat((Object)http.header("A"), (Matcher)Matchers.is((Object)"A"));
                Assert.assertThat((Object)http.header("B"), (Matcher)Matchers.is((Object)"B1"));
                Assert.assertThat((Object)http.headers("A"), (Matcher)Matchers.contains((Object[])new String[]{"A"}));
                Assert.assertThat((Object)http.headers("B"), (Matcher)Matchers.contains((Object[])new String[]{"B1", "B2"}));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.header("A", "A").header("B", "B1").header("B", "B2");
            }
        }).send();
    }

    @Test
    public void read_text() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                final StringBuilder body = new StringBuilder();
                http.onchunk((Action)new Action<String>(){

                    public void on(String data) {
                        body.append(data);
                    }
                }).onend((Action)new VoidAction(){

                    public void on() {
                        Assert.assertThat((Object)body.toString(), (Matcher)Matchers.is((Object)"A Breath Clad In Happiness"));
                        ServerHttpExchangeTest.this.performer.start();
                    }
                }).read();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("A Breath Clad In Happiness"), "text/plain; charset=utf-8");
            }
        }).send();
    }

    @Test
    public void readAsText() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                final StringBuilder body = new StringBuilder();
                http.onchunk((Action)new Action<String>(){

                    public void on(String data) {
                        body.append(data);
                    }
                }).onend((Action)new VoidAction(){

                    public void on() {
                        Assert.assertThat((Object)body.toString(), (Matcher)Matchers.is((Object)"Day 7: Poem of the Ocean"));
                        ServerHttpExchangeTest.this.performer.start();
                    }
                }).readAsText();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("Day 7: Poem of the Ocean"), "application/octet-stream");
            }
        }).send();
    }

    @Test
    public void readAsText_charset() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                final StringBuilder body = new StringBuilder();
                http.onchunk((Action)new Action<String>(){

                    public void on(String data) {
                        body.append(data);
                    }
                }).onend((Action)new VoidAction(){

                    public void on() {
                        Assert.assertThat((Object)body.toString(), (Matcher)Matchers.is((Object)"\uc2dc\uac04 \uc18d\uc5d0 \ub9cc\ub4e4\uc5b4\uc9c4 \ubb34\ub300 \uc704\uc5d0 \uadf8\ub300\ub294 \uc5c6\ub2e4"));
                        ServerHttpExchangeTest.this.performer.start();
                    }
                }).readAsText("utf-8");
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("\uc2dc\uac04 \uc18d\uc5d0 \ub9cc\ub4e4\uc5b4\uc9c4 \ubb34\ub300 \uc704\uc5d0 \uadf8\ub300\ub294 \uc5c6\ub2e4", "utf-8"), "text/plain; charset=euc-kr");
            }
        }).send();
    }

    @Test
    public void read_binary() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                final ByteArrayOutputStream body = new ByteArrayOutputStream();
                http.onchunk((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        byte[] bytes = new byte[data.remaining()];
                        data.get(bytes);
                        body.write(bytes, 0, bytes.length);
                    }
                }).onend((Action)new VoidAction(){

                    public void on() {
                        Assert.assertThat((Object)body.toByteArray(), (Matcher)Matchers.is((Object)new byte[]{104, 105}));
                        ServerHttpExchangeTest.this.performer.start();
                    }
                }).read();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{{104, 105}}), "application/octet-stream");
            }
        }).send();
    }

    @Test
    public void readAsBinary() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                final ByteArrayOutputStream body = new ByteArrayOutputStream();
                http.onchunk((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        byte[] bytes = new byte[data.remaining()];
                        data.get(bytes);
                        body.write(bytes, 0, bytes.length);
                    }
                }).onend((Action)new VoidAction(){

                    public void on() {
                        Assert.assertThat((Object)body.toByteArray(), (Matcher)Matchers.is((Object)new byte[]{104, 105}));
                        ServerHttpExchangeTest.this.performer.start();
                    }
                }).readAsBinary();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{{104, 105}}), "text/plain");
            }
        }).send();
    }

    @Test
    public void onbody_with_text() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.onbody((Action)new Action<String>(){

                    public void on(String data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)"A Breath Clad In Happiness"));
                        ServerHttpExchangeTest.this.performer.start();
                    }
                }).read();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("A Breath Clad In Happiness"), "text/plain; charset=utf-8");
            }
        }).send();
    }

    @Test
    public void onbody_with_binary() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.onbody((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)ByteBuffer.wrap(new byte[]{104, 105})));
                        ServerHttpExchangeTest.this.performer.start();
                    }
                }).read();
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onBegin(Request request) {
                request.method(HttpMethod.POST).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{{104, 105}}), "application/octet-stream");
            }
        }).send();
    }

    @Test
    public void setStatus() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.setStatus(HttpStatus.NOT_FOUND).end();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){

            public void onSuccess(Response response) {
                Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).send();
    }

    @Test
    public void setHeader() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.setHeader("A", "A").setHeader("B", Arrays.asList("B1", "B2")).end();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){

            public void onSuccess(Response res) {
                HttpFields headers = res.getHeaders();
                Assert.assertThat((Object)headers.getFieldNamesCollection(), (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B"}));
                Assert.assertThat((Object)headers.get("A"), (Matcher)Matchers.is((Object)"A"));
                Assert.assertThat((Object)headers.get("B"), (Matcher)Matchers.is((Object)"B1, B2"));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).send();
    }

    @Test
    public void write_text() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.setHeader("content-type", "text/plain; charset=euc-kr").write("\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c").end().onfinish((Action)new VoidAction(){

                    public void on() {
                        latch.countDown();
                    }
                });
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){
            String body;

            public void onContent(Response response, ByteBuffer content) {
                this.body = Charset.forName("euc-kr").decode(content).toString();
            }

            public void onSuccess(Response response) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertThat((Object)this.body, (Matcher)Matchers.is((Object)"\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c"));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).send();
    }

    @Test
    public void write_text_charset() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.onfinish((Action)new VoidAction(){

                    public void on() {
                        latch.countDown();
                    }
                }).end("\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c", "euc-kr");
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){
            String body;

            public void onContent(Response response, ByteBuffer content) {
                this.body = Charset.forName("euc-kr").decode(content).toString();
            }

            public void onSuccess(Response response) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertThat((Object)this.body, (Matcher)Matchers.is((Object)"\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c"));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).send();
    }

    @Test
    public void write_binary() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.write(ByteBuffer.wrap(new byte[]{104, 101}).asReadOnlyBuffer()).write(ByteBuffer.wrap(new byte[]{108, 108})).end(ByteBuffer.wrap(new byte[]{111})).onfinish((Action)new VoidAction(){

                    public void on() {
                        latch.countDown();
                    }
                });
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){
            ByteArrayOutputStream os = new ByteArrayOutputStream();

            public void onContent(Response response, ByteBuffer content) {
                byte[] bytes = new byte[content.remaining()];
                content.get(bytes);
                this.os.write(bytes, 0, bytes.length);
            }

            public void onSuccess(Response response) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertThat((Object)this.os.toByteArray(), (Matcher)Matchers.is((Object)new byte[]{104, 101, 108, 108, 111}));
                ServerHttpExchangeTest.this.performer.start();
            }
        }).send();
    }

    @Test
    public void end() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.end();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){

            public void onSuccess(Response response) {
                ServerHttpExchangeTest.this.performer.start();
            }
        }).send();
    }

    @Test
    public void onclose() {
        this.performer.onserver(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.onclose((Action)new VoidAction(){

                    public void on() {
                        ServerHttpExchangeTest.this.performer.start();
                    }
                });
            }
        }).requestListener((Request.Listener)new Request.Listener.Adapter(){

            public void onCommit(Request request) {
                request.abort((Throwable)new Exception());
            }
        }).send();
    }

    protected class Performer {
        CountDownLatch latch = new CountDownLatch(1);
        Request.Listener requestListener = new Request.Listener.Adapter();
        Response.Listener responseListener = new Response.Listener.Adapter();
        Action<ServerHttpExchange> serverAction = new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange object) {
            }
        };

        protected Performer() {
        }

        public Performer requestListener(Request.Listener requestListener) {
            this.requestListener = requestListener;
            return this;
        }

        public Performer responseListener(Response.Listener responseListener) {
            this.responseListener = responseListener;
            return this;
        }

        public Action<ServerHttpExchange> serverAction() {
            return new Action<ServerHttpExchange>(){

                public void on(ServerHttpExchange http) {
                    Performer.this.serverAction.on((Object)http);
                }
            };
        }

        public Performer onserver(Action<ServerHttpExchange> serverAction) {
            this.serverAction = serverAction;
            return this;
        }

        public Performer send() {
            return this.send("/test");
        }

        public Performer send(String uri) {
            HttpClient client = new HttpClient();
            try {
                client.start();
                client.newRequest("http://localhost:" + ServerHttpExchangeTest.this.port + uri).listener(this.requestListener).send((Response.CompleteListener)this.responseListener);
                this.latch.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    client.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        public Performer start() {
            this.latch.countDown();
            return this;
        }
    }
}

