/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.platform.bridge.jwa1;

import io.cettia.platform.websocket.AbstractServerWebSocket;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;

public class JwaServerWebSocket
extends AbstractServerWebSocket {
    private final Session session;
    private final SendHandler sendHandler = new SendHandler(){

        public void onResult(SendResult result) {
            if (!result.isOK()) {
                JwaServerWebSocket.this.errorActions.fire((Object)result.getException());
            }
        }
    };

    public JwaServerWebSocket(Session session) {
        this.session = session;
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                JwaServerWebSocket.this.textActions.fire((Object)message);
            }
        });
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

            public void onMessage(ByteBuffer message) {
                JwaServerWebSocket.this.binaryActions.fire((Object)message);
            }
        });
    }

    void onError(Throwable e) {
        this.errorActions.fire((Object)e);
    }

    void onClose() {
        this.closeActions.fire();
    }

    public String uri() {
        URI uri = this.session.getRequestURI();
        return uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
    }

    protected void doClose() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.session.getAsyncRemote().sendBinary(byteBuffer, this.sendHandler);
    }

    protected void doSend(String data) {
        this.session.getAsyncRemote().sendText(data, this.sendHandler);
    }

    public <T> T unwrap(Class<T> clazz) {
        return Session.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.session) : null;
    }
}

