/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.websocket;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.action.SimpleActions;
import io.cettia.asity.websocket.ServerWebSocket;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerWebSocket
implements ServerWebSocket {
    protected final Actions<String> textActions = new SimpleActions();
    protected final Actions<ByteBuffer> binaryActions = new SimpleActions();
    protected final Actions<Throwable> errorActions = new SimpleActions();
    protected final Actions<Void> closeActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private final Logger logger = LoggerFactory.getLogger(AbstractServerWebSocket.class);
    private State state = State.OPEN;

    public AbstractServerWebSocket() {
        this.closeActions.add($ -> {
            this.state = State.CLOSED;
        });
        if (this.logger.isDebugEnabled()) {
            this.textActions.add(frame -> this.logger.debug("{} receives a text frame {}", (Object)this, frame));
            this.binaryActions.add(frame -> this.logger.debug("{} receives a binary frame {}", (Object)this, frame));
            this.errorActions.add(throwable -> this.logger.debug("{} has received a throwable {}", (Object)this, throwable));
            this.closeActions.add($ -> this.logger.debug("{} has been closed", (Object)this));
        }
    }

    @Override
    public String header(String name) {
        List<String> headers = this.headers(name);
        return headers != null && headers.size() > 0 ? headers.get(0) : null;
    }

    @Override
    public void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} has started to close the connection", (Object)this);
        }
        if (this.state != State.CLOSING && this.state != State.CLOSED) {
            this.state = State.CLOSING;
            this.doClose();
        }
    }

    protected abstract void doClose();

    @Override
    public ServerWebSocket send(String data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} sends a text frame {}", (Object)this, (Object)data);
        }
        this.doSend(data);
        return this;
    }

    @Override
    public ServerWebSocket send(ByteBuffer byteBuffer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} sends a binary frame {}", (Object)this, (Object)byteBuffer);
        }
        this.doSend(byteBuffer);
        return this;
    }

    protected abstract void doSend(ByteBuffer var1);

    protected abstract void doSend(String var1);

    @Override
    public ServerWebSocket ontext(Action<String> action) {
        this.textActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket onbinary(Action<ByteBuffer> action) {
        this.binaryActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket onclose(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket onerror(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }

    public String toString() {
        return String.format("%s@%x[state=%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.state});
    }

    private static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

