/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.test;

import io.cettia.asity.action.Action;
import io.cettia.asity.http.HttpStatus;
import io.cettia.asity.http.ServerHttpExchange;
import java.io.ByteArrayOutputStream;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import net.jodah.concurrentunit.ConcurrentTestCase;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class ServerHttpExchangeTestBase
extends ConcurrentTestCase {
    protected static final String TEST_URI = "/test";
    private static final Response.CompleteListener ASYNC = new Response.Listener.Adapter();
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)30L);
    protected HttpClient client = new HttpClient();
    private int port;
    private Action<ServerHttpExchange> requestAction;

    @Before
    public void setUp() throws Exception {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            this.port = serverSocket.getLocalPort();
        }
        this.client.start();
        this.startServer(this.port, (Action<ServerHttpExchange>)((Action)http -> this.requestAction.on(http)));
    }

    @After
    public void tearDown() throws Exception {
        this.stopServer();
        this.client.stop();
        this.requestAction = null;
    }

    protected abstract void startServer(int var1, Action<ServerHttpExchange> var2) throws Exception;

    protected abstract void stopServer() throws Exception;

    protected String uri() {
        return this.uri(TEST_URI);
    }

    protected String uri(String path) {
        return "http://localhost:" + this.port + path;
    }

    protected void requestAction(Action<ServerHttpExchange> requestAction) {
        this.requestAction = requestAction;
    }

    @Test
    public void testURI() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            this.threadAssertEquals(http.uri(), "/test?hello=there");
            this.resume();
        }));
        this.client.newRequest(this.uri("/test?hello=there")).send(ASYNC);
        this.await();
    }

    @Test
    public void testMethod() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            this.threadAssertEquals(http.method(), io.cettia.asity.http.HttpMethod.POST);
            this.resume();
        }));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).send(ASYNC);
        this.await();
    }

    @Test
    public void testHeader() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            this.threadAssertTrue(http.headerNames().containsAll(Arrays.asList("a", "b")) || http.headerNames().containsAll(Arrays.asList("A", "B")));
            this.threadAssertEquals(http.header("A"), "A");
            this.threadAssertEquals(http.header("B"), "B1");
            this.threadAssertTrue(http.headers("A").containsAll(Arrays.asList("A")));
            this.threadAssertTrue(http.headers("B").containsAll(Arrays.asList("B1", "B2")));
            this.resume();
        }));
        this.client.newRequest(this.uri()).header("A", "A").header("B", "B1").header("B", "B2").send(ASYNC);
        this.await();
    }

    @Test
    public void testReadText() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            StringBuilder body = new StringBuilder();
            http.onchunk(body::append).onend($ -> {
                this.threadAssertEquals(body.toString(), "A Breath Clad In Happiness");
                this.resume();
            }).read();
        }));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("A Breath Clad In Happiness"), "text/plain; charset=utf-8").send(ASYNC);
        this.await();
    }

    @Test
    public void testReadAsText() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            StringBuilder body = new StringBuilder();
            http.onchunk(body::append).onend($ -> {
                this.threadAssertEquals(body.toString(), "Day 7: Poem of the Ocean");
                this.resume();
            }).readAsText();
        }));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("Day 7: Poem of the Ocean"), "application/octet-stream").send(ASYNC);
        this.await();
    }

    @Test
    public void testReadAsTextWithCharset() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            StringBuilder body = new StringBuilder();
            http.onchunk(body::append).onend($ -> {
                this.threadAssertEquals(body.toString(), "\uc2dc\uac04 \uc18d\uc5d0 \ub9cc\ub4e4\uc5b4\uc9c4 \ubb34\ub300 \uc704\uc5d0 \uadf8\ub300\ub294 \uc5c6\ub2e4");
                this.resume();
            }).readAsText("utf-8");
        }));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("\uc2dc\uac04 \uc18d\uc5d0 \ub9cc\ub4e4\uc5b4\uc9c4 \ubb34\ub300 \uc704\uc5d0 \uadf8\ub300\ub294 \uc5c6\ub2e4", "utf-8"), "text/plain; charset=euc-kr").send(ASYNC);
        this.await();
    }

    @Test
    public void testReadBinary() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            http.onchunk(data -> {
                byte[] bytes = new byte[data.remaining()];
                data.get(bytes);
                body.write(bytes, 0, bytes.length);
            }).onend($ -> {
                this.threadAssertTrue(Arrays.equals(body.toByteArray(), new byte[]{104, 105}));
                this.resume();
            }).read();
        }));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{{104, 105}}), "application/octet-stream").send(ASYNC);
        this.await();
    }

    @Test
    public void testReadAsBinary() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> {
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            http.onchunk(data -> {
                byte[] bytes = new byte[data.remaining()];
                data.get(bytes);
                body.write(bytes, 0, bytes.length);
            }).onend($ -> {
                this.threadAssertTrue(Arrays.equals(body.toByteArray(), new byte[]{104, 105}));
                this.resume();
            }).readAsBinary();
        }));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{{104, 105}}), "text/plain").send(ASYNC);
        this.await();
    }

    @Test
    public void testOnbodyWithText() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.onbody(data -> {
            this.threadAssertEquals(data, "A Breath Clad In Happiness");
            this.resume();
        }).read()));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("A Breath Clad In Happiness"), "text/plain; charset=utf-8").send(ASYNC);
        this.await();
    }

    @Test
    public void testOnbodyWithBinary() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.onbody(data -> {
            this.threadAssertEquals(data, ByteBuffer.wrap(new byte[]{104, 105}));
            this.resume();
        }).read()));
        this.client.newRequest(this.uri()).method(HttpMethod.POST).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{{104, 105}}), "application/octet-stream").send(ASYNC);
        this.await();
    }

    @Test
    public void testSetStatus() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.setStatus(HttpStatus.NOT_FOUND).end()));
        this.client.newRequest(this.uri()).send((Response.CompleteListener)new Response.Listener.Adapter(){

            public void onSuccess(Response response) {
                ServerHttpExchangeTestBase.this.threadAssertEquals(response.getStatus(), 404);
                ServerHttpExchangeTestBase.this.resume();
            }
        });
        this.await();
    }

    @Test
    public void testSetHeader() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.setHeader("A", "A").setHeader("B", Arrays.asList("B1", "B2")).end()));
        this.client.newRequest(this.uri()).send((Response.CompleteListener)new Response.Listener.Adapter(){

            public void onSuccess(Response res) {
                HttpFields headers = res.getHeaders();
                ServerHttpExchangeTestBase.this.threadAssertTrue(headers.getFieldNamesCollection().containsAll(Arrays.asList("A", "B")));
                ServerHttpExchangeTestBase.this.threadAssertEquals(headers.get("A"), "A");
                ServerHttpExchangeTestBase.this.threadAssertEquals(headers.get("B"), "B1, B2");
                ServerHttpExchangeTestBase.this.resume();
            }
        });
        this.await();
    }

    @Test
    public void testWriteText() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.setHeader("content-type", "text/plain; charset=euc-kr").write("\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c").end().onfinish($ -> latch.countDown())));
        this.client.newRequest(this.uri()).send((Response.CompleteListener)new Response.Listener.Adapter(){
            String body;

            public void onContent(Response response, ByteBuffer content) {
                this.body = Charset.forName("euc-kr").decode(content).toString();
            }

            public void onSuccess(Response res) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ServerHttpExchangeTestBase.this.threadAssertEquals(this.body, "\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c");
                ServerHttpExchangeTestBase.this.resume();
            }
        });
        this.await();
    }

    @Test
    public void testWriteTextWithCharset() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.onfinish($ -> latch.countDown()).end("\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c", "euc-kr")));
        this.client.newRequest(this.uri()).send((Response.CompleteListener)new Response.Listener.Adapter(){
            String body;

            public void onContent(Response response, ByteBuffer content) {
                this.body = Charset.forName("euc-kr").decode(content).toString();
            }

            public void onSuccess(Response res) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ServerHttpExchangeTestBase.this.threadAssertEquals(this.body, "\uae30\uc5b5 \uc18d\uc5d0 \uba38\ubb34\ub978 \uadf8 \ub54c\uc758 \ubaa8\uc2b5\uc73c\ub85c \uadf8\ub54c\uc758 \uc6c3\uc74c\uc73c\ub85c");
                ServerHttpExchangeTestBase.this.resume();
            }
        });
        this.await();
    }

    @Test
    public void testWriteBinary() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.write(ByteBuffer.wrap(new byte[]{104, 101}).asReadOnlyBuffer()).write(ByteBuffer.wrap(new byte[]{108, 108})).end(ByteBuffer.wrap(new byte[]{111})).onfinish($ -> latch.countDown())));
        this.client.newRequest(this.uri()).send((Response.CompleteListener)new Response.Listener.Adapter(){
            ByteArrayOutputStream os = new ByteArrayOutputStream();

            public void onContent(Response response, ByteBuffer content) {
                byte[] bytes = new byte[content.remaining()];
                content.get(bytes);
                this.os.write(bytes, 0, bytes.length);
            }

            public void onSuccess(Response response) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ServerHttpExchangeTestBase.this.threadAssertTrue(Arrays.equals(this.os.toByteArray(), new byte[]{104, 101, 108, 108, 111}));
                ServerHttpExchangeTestBase.this.resume();
            }
        });
        this.await();
    }

    @Test
    public void testEnd() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)ServerHttpExchange::end));
        this.client.newRequest(this.uri()).send((Response.CompleteListener)new Response.Listener.Adapter(){

            public void onSuccess(Response response) {
                ServerHttpExchangeTestBase.this.resume();
            }
        });
        this.await();
    }

    @Test
    public void testOnclose() throws Throwable {
        this.requestAction((Action<ServerHttpExchange>)((Action)http -> http.onclose($ -> this.resume())));
        this.client.newRequest(this.uri()).listener((Request.Listener)new Request.Listener.Adapter(){

            public void onCommit(Request request) {
                request.abort((Throwable)new Exception());
            }
        }).send(ASYNC);
        this.await();
    }
}

