/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.test;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.VoidAction;
import io.cettia.asity.websocket.ServerWebSocket;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jodah.concurrentunit.ConcurrentTestCase;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class ServerWebSocketTestBase
extends ConcurrentTestCase {
    protected static final String TEST_URI = "/test";
    private static final WebSocketListener NOOP = new WebSocketAdapter();
    private static final WriteCallback ASYNC = new WriteCallback(){

        public void writeSuccess() {
        }

        public void writeFailed(Throwable throwable) {
        }
    };
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)30L);
    protected WebSocketClient client = new WebSocketClient();
    private int port;
    private Action<ServerWebSocket> websocketAction;

    @Before
    public void setUp() throws Exception {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            this.port = serverSocket.getLocalPort();
        }
        this.client.start();
        this.startServer(this.port, new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ServerWebSocketTestBase.this.websocketAction.on((Object)ws);
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.stopServer();
        this.client.stop();
        this.websocketAction = null;
    }

    protected abstract void startServer(int var1, Action<ServerWebSocket> var2) throws Exception;

    protected abstract void stopServer() throws Exception;

    protected String uri() {
        return this.uri(TEST_URI);
    }

    protected String uri(String path) {
        return "ws://localhost:" + this.port + path;
    }

    protected void websocketAction(Action<ServerWebSocket> websocketAction) {
        this.websocketAction = websocketAction;
    }

    @Test
    public void testURI() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ServerWebSocketTestBase.this.threadAssertEquals(ws.uri(), "/test?hello=there");
                ServerWebSocketTestBase.this.resume();
            }
        });
        this.client.connect((Object)NOOP, URI.create(this.uri("/test?hello=there")));
        this.await();
    }

    @Test
    public void testClose() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.close();
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){

            public void onWebSocketClose(int statusCode, String reason) {
                ServerWebSocketTestBase.this.resume();
            }
        }, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testSendTextFrame() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send("A Will Remains in the Ashes");
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){

            public void onWebSocketText(String message) {
                ServerWebSocketTestBase.this.threadAssertEquals(message, "A Will Remains in the Ashes");
                ServerWebSocketTestBase.this.resume();
            }
        }, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testSendBinaryFrame() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send(ByteBuffer.wrap(new byte[]{0, 1, 2}).asReadOnlyBuffer());
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){

            public void onWebSocketBinary(byte[] payload, int offset, int len) {
                ServerWebSocketTestBase.this.threadAssertTrue(Arrays.equals(payload, new byte[]{0, 1, 2}));
                ServerWebSocketTestBase.this.resume();
            }
        }, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testSendTextFrameAndBinaryFrameTogether() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send("A Will Remains in the Ashes").send(ByteBuffer.wrap(new byte[]{0, 1, 2}));
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){
            boolean done;

            public void onWebSocketText(String message) {
                ServerWebSocketTestBase.this.threadAssertEquals(message, "A Will Remains in the Ashes");
                if (this.done) {
                    ServerWebSocketTestBase.this.resume();
                } else {
                    this.done = true;
                }
            }

            public void onWebSocketBinary(byte[] payload, int offset, int len) {
                ServerWebSocketTestBase.this.threadAssertTrue(Arrays.equals(payload, new byte[]{0, 1, 2}));
                if (this.done) {
                    ServerWebSocketTestBase.this.resume();
                } else {
                    this.done = true;
                }
            }
        }, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testOntext() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.ontext((Action)new Action<String>(){

                    public void on(String data) {
                        ServerWebSocketTestBase.this.threadAssertEquals(data, "A road of winds the water builds");
                        ServerWebSocketTestBase.this.resume();
                    }
                });
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){

            public void onWebSocketConnect(Session session) {
                session.getRemote().sendString("A road of winds the water builds", ASYNC);
            }
        }, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testOnbinary() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.onbinary((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        ServerWebSocketTestBase.this.threadAssertEquals(data, ByteBuffer.wrap(new byte[]{0, 1, 2}));
                        ServerWebSocketTestBase.this.resume();
                    }
                });
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){

            public void onWebSocketConnect(Session session) {
                session.getRemote().sendBytes(ByteBuffer.wrap(new byte[]{0, 1, 2}), ASYNC);
            }
        }, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testOntextAndOnbinary() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){
            boolean done;

            public void on(ServerWebSocket ws) {
                ws.ontext((Action)new Action<String>(){

                    public void on(String data) {
                        ServerWebSocketTestBase.this.threadAssertEquals(data, "A road of winds the water builds");
                        if (done) {
                            ServerWebSocketTestBase.this.resume();
                        } else {
                            done = true;
                        }
                    }
                }).onbinary((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        ServerWebSocketTestBase.this.threadAssertEquals(data, ByteBuffer.wrap(new byte[]{0, 1, 2}));
                        if (done) {
                            ServerWebSocketTestBase.this.resume();
                        } else {
                            done = true;
                        }
                    }
                });
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){

            public void onWebSocketConnect(Session session) {
                session.getRemote().sendString("A road of winds the water builds", ASYNC);
                session.getRemote().sendBytes(ByteBuffer.wrap(new byte[]{0, 1, 2}), ASYNC);
            }
        }, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testOncloseByServer() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.onclose((Action)new VoidAction(){

                    public void on() {
                        ServerWebSocketTestBase.this.resume();
                    }
                }).close();
            }
        });
        this.client.connect((Object)NOOP, URI.create(this.uri()));
        this.await();
    }

    @Test
    public void testOncloseByClient() throws Throwable {
        this.websocketAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.onclose((Action)new VoidAction(){

                    public void on() {
                        ServerWebSocketTestBase.this.resume();
                    }
                });
            }
        });
        this.client.connect((Object)new WebSocketAdapter(){

            public void onWebSocketConnect(Session session) {
                session.close();
            }
        }, URI.create(this.uri()));
        this.await();
    }
}

