/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.http;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.action.SimpleActions;
import io.cettia.asity.http.HttpStatus;
import io.cettia.asity.http.ServerHttpExchange;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerHttpExchange
implements ServerHttpExchange {
    private static final String DEFAULT_CHARSET_NAME = "ISO-8859-1";
    protected final Actions<Void> endActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    protected final Actions<Throwable> errorActions = new SimpleActions();
    protected final Actions<Void> closeActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private final Logger logger = LoggerFactory.getLogger(AbstractServerHttpExchange.class);
    private final Actions<Object> chunkActions = new SimpleActions();
    private final Actions<Object> bodyActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private final Actions<Void> finishActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private String writeCharsetName = "ISO-8859-1";
    private boolean reading;
    private boolean readingBody;
    private boolean requestEnded;
    private boolean writing;
    private boolean responseEnded;

    public AbstractServerHttpExchange() {
        this.endActions.add($ -> {
            this.requestEnded = true;
        });
        if (this.logger.isDebugEnabled()) {
            this.endActions.add($ -> this.logger.debug("{} request has ended", (Object)this));
            this.finishActions.add($ -> this.logger.debug("{} response has ended", (Object)this));
            this.errorActions.add(throwable -> this.logger.debug("{} has received a throwable {}", (Object)this, throwable));
            this.closeActions.add($ -> this.logger.debug("{} has been aborted", (Object)this));
        }
    }

    @Override
    public String header(String name) {
        List<String> headers = this.headers(name);
        return headers != null && headers.size() > 0 ? headers.get(0) : null;
    }

    @Override
    public ServerHttpExchange read() {
        if (!this.reading) {
            if (this.hasTextBody()) {
                this.readAsText();
            } else {
                this.readAsBinary();
            }
        }
        return this;
    }

    private boolean hasTextBody() {
        String contentType = this.header("content-type");
        return contentType != null && contentType.startsWith("text/");
    }

    @Override
    public ServerHttpExchange readAsText() {
        return this.readAsText(this.findCharsetName(this.header("content-type")));
    }

    private String findCharsetName(String contentType) {
        int idx;
        String charsetName = DEFAULT_CHARSET_NAME;
        if (contentType != null && (idx = contentType.indexOf("charset=")) != -1) {
            charsetName = contentType.substring(idx + "charset=".length());
        }
        return charsetName;
    }

    @Override
    public ServerHttpExchange readAsText(String charsetName) {
        if (!this.reading) {
            this.reading = true;
            Charset charset = Charset.forName(charsetName);
            this.doRead((Action<ByteBuffer>)((Action)byteBuffer -> {
                String chunk = charset.decode((ByteBuffer)byteBuffer).toString();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} reads a text chunk {} with charset {}", new Object[]{this, chunk, charsetName});
                }
                this.chunkActions.fire((Object)chunk);
            }));
        }
        return this;
    }

    @Override
    public ServerHttpExchange readAsBinary() {
        if (!this.reading) {
            this.reading = true;
            this.doRead((Action<ByteBuffer>)((Action)byteBuffer -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} reads a binary chunk {}", (Object)this, byteBuffer);
                }
                this.chunkActions.fire(byteBuffer);
            }));
        }
        return this;
    }

    protected abstract void doRead(Action<ByteBuffer> var1);

    public ServerHttpExchange onchunk(Action action) {
        this.chunkActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange onend(Action<Void> action) {
        this.endActions.add(action);
        return this;
    }

    public ServerHttpExchange onbody(Action action) {
        if (!this.readingBody) {
            this.readingBody = true;
            if (this.hasTextBody()) {
                StringBuilder body = new StringBuilder();
                this.chunkActions.add(data -> body.append((String)data));
                this.endActions.add($ -> this.bodyActions.fire((Object)body.toString()));
            } else {
                ByteArrayOutputStream body = new ByteArrayOutputStream();
                this.chunkActions.add(data -> {
                    ByteBuffer byteBuffer = (ByteBuffer)data;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    body.write(bytes, 0, bytes.length);
                });
                this.endActions.add($ -> this.bodyActions.fire((Object)ByteBuffer.wrap(body.toByteArray())));
            }
        }
        this.bodyActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange setStatus(HttpStatus status) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} sets a response status {}", (Object)this, (Object)status);
        }
        this.doSetStatus(status);
        return this;
    }

    protected abstract void doSetStatus(HttpStatus var1);

    @Override
    public final ServerHttpExchange setHeader(String name, Iterable<String> value) {
        Iterator<String> iterator = value.iterator();
        StringBuilder builder = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            builder.append(", ").append(iterator.next());
        }
        return this.setHeader(name, builder.toString());
    }

    @Override
    public ServerHttpExchange setHeader(String name, String value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} sets a response header {} to {}", new Object[]{this, name, value});
        }
        if (name.equalsIgnoreCase("content-type")) {
            this.writeCharsetName = this.findCharsetName(value);
        }
        this.doSetHeader(name, value);
        return this;
    }

    protected abstract void doSetHeader(String var1, String var2);

    @Override
    public ServerHttpExchange write(String data) {
        return this.write(data, this.writeCharsetName);
    }

    @Override
    public ServerHttpExchange write(String data, String charsetName) {
        this.writing = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} writes a text chunk {} with charset {}", new Object[]{this, data, charsetName});
        }
        this.doWrite(Charset.forName(charsetName).encode(data));
        return this;
    }

    @Override
    public ServerHttpExchange write(ByteBuffer byteBuffer) {
        this.writing = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} writes a binary chunk {}", (Object)this, (Object)byteBuffer);
        }
        this.doWrite(byteBuffer);
        return this;
    }

    protected abstract void doWrite(ByteBuffer var1);

    @Override
    public ServerHttpExchange end() {
        if (!this.responseEnded) {
            this.responseEnded = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} ends the response", (Object)this);
            }
            this.doEnd();
            this.finishActions.fire();
        }
        return this;
    }

    protected abstract void doEnd();

    @Override
    public ServerHttpExchange end(String data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange end(String data, String charsetName) {
        return this.write(data, charsetName).end();
    }

    @Override
    public ServerHttpExchange end(ByteBuffer data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange onfinish(Action<Void> action) {
        this.finishActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange onclose(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange onerror(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }

    public String toString() {
        String requestState;
        String string = this.requestEnded ? "ENDED" : (requestState = this.reading ? "READING" : "UNREAD");
        String responseState = this.responseEnded ? "ENDED" : (this.writing ? "WRITING" : "UNWRITTEN");
        return String.format("%s@%x[request=%s,response=%s]", this.getClass().getSimpleName(), this.hashCode(), requestState, responseState);
    }
}

