/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.http;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.action.SimpleActions;
import io.cettia.asity.action.VoidAction;
import io.cettia.asity.http.HttpStatus;
import io.cettia.asity.http.ServerHttpExchange;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerHttpExchange
implements ServerHttpExchange {
    protected final Actions<Void> endActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    protected final Actions<Throwable> errorActions = new SimpleActions();
    protected final Actions<Void> closeActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private final Logger logger = LoggerFactory.getLogger(AbstractServerHttpExchange.class);
    private final Actions<Object> chunkActions = new SimpleActions();
    private final Actions<Object> bodyActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private final Actions<Void> finishActions = new SimpleActions(new Actions.Options().once(true).memory(true));
    private boolean read;
    private boolean readBody;
    private boolean ended;
    private String writeCharsetName = "ISO-8859-1";

    public AbstractServerHttpExchange() {
        this.endActions.add((Action)new VoidAction(){

            public void on() {
                AbstractServerHttpExchange.this.logger.trace("{}'s request has ended", (Object)AbstractServerHttpExchange.this);
            }
        });
        this.finishActions.add((Action)new VoidAction(){

            public void on() {
                AbstractServerHttpExchange.this.logger.trace("{}'s response has ended", (Object)AbstractServerHttpExchange.this);
            }
        });
        this.errorActions.add((Action)new Action<Throwable>(){

            public void on(Throwable throwable) {
                AbstractServerHttpExchange.this.logger.trace("{} has received a throwable {}", (Object)AbstractServerHttpExchange.this, (Object)throwable);
            }
        });
        this.closeActions.add((Action)new VoidAction(){

            public void on() {
                AbstractServerHttpExchange.this.logger.trace("{} has been closed", (Object)AbstractServerHttpExchange.this);
            }
        });
    }

    @Override
    public String header(String name) {
        List<String> headers = this.headers(name);
        return headers != null && headers.size() > 0 ? headers.get(0) : null;
    }

    @Override
    public ServerHttpExchange read() {
        if (!this.read) {
            if (this.hasTextBody()) {
                this.readAsText();
            } else {
                this.readAsBinary();
            }
        }
        return this;
    }

    private boolean hasTextBody() {
        String contentType = this.header("content-type");
        return contentType != null && contentType.startsWith("text/");
    }

    @Override
    public ServerHttpExchange readAsText() {
        return this.readAsText(this.findCharsetName(this.header("content-type")));
    }

    private String findCharsetName(String contentType) {
        int idx;
        String charsetName = "ISO-8859-1";
        if (contentType != null && (idx = contentType.indexOf("charset=")) != -1) {
            charsetName = contentType.substring(idx + "charset=".length());
        }
        return charsetName;
    }

    @Override
    public ServerHttpExchange readAsText(String charsetName) {
        if (!this.read) {
            this.read = true;
            final Charset charset = Charset.forName(charsetName);
            this.doRead(new Action<ByteBuffer>(){

                public void on(ByteBuffer byteBuffer) {
                    AbstractServerHttpExchange.this.chunkActions.fire((Object)charset.decode(byteBuffer).toString());
                }
            });
        }
        return this;
    }

    @Override
    public ServerHttpExchange readAsBinary() {
        if (!this.read) {
            this.read = true;
            this.doRead(new Action<ByteBuffer>(){

                public void on(ByteBuffer byteBuffer) {
                    AbstractServerHttpExchange.this.chunkActions.fire((Object)byteBuffer);
                }
            });
        }
        return this;
    }

    protected abstract void doRead(Action<ByteBuffer> var1);

    public ServerHttpExchange onchunk(Action action) {
        this.chunkActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange onend(Action<Void> action) {
        this.endActions.add(action);
        return this;
    }

    public ServerHttpExchange onbody(Action action) {
        if (!this.readBody) {
            this.readBody = true;
            if (this.hasTextBody()) {
                final StringBuilder body = new StringBuilder();
                this.chunkActions.add((Action)new Action<Object>(){

                    public void on(Object data) {
                        body.append((String)data);
                    }
                });
                this.endActions.add((Action)new VoidAction(){

                    public void on() {
                        AbstractServerHttpExchange.this.bodyActions.fire((Object)body.toString());
                    }
                });
            } else {
                final ByteArrayOutputStream body = new ByteArrayOutputStream();
                this.chunkActions.add((Action)new Action<Object>(){

                    public void on(Object data) {
                        ByteBuffer byteBuffer = (ByteBuffer)data;
                        byte[] bytes = new byte[byteBuffer.remaining()];
                        byteBuffer.get(bytes);
                        body.write(bytes, 0, bytes.length);
                    }
                });
                this.endActions.add((Action)new VoidAction(){

                    public void on() {
                        AbstractServerHttpExchange.this.bodyActions.fire((Object)ByteBuffer.wrap(body.toByteArray()));
                    }
                });
            }
        }
        this.bodyActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange setStatus(HttpStatus status) {
        this.logger.trace("{} sets a response status, {}", (Object)this, (Object)status);
        this.doSetStatus(status);
        return this;
    }

    protected abstract void doSetStatus(HttpStatus var1);

    @Override
    public final ServerHttpExchange setHeader(String name, Iterable<String> value) {
        Iterator<String> iterator = value.iterator();
        StringBuilder builder = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            builder.append(", ").append(iterator.next());
        }
        return this.setHeader(name, builder.toString());
    }

    @Override
    public ServerHttpExchange setHeader(String name, String value) {
        this.logger.trace("{} sets a response header {} to {}", new Object[]{this, name, value});
        if (name.equalsIgnoreCase("content-type")) {
            this.writeCharsetName = this.findCharsetName(value);
        }
        this.doSetHeader(name, value);
        return this;
    }

    protected abstract void doSetHeader(String var1, String var2);

    @Override
    public ServerHttpExchange write(String data) {
        return this.write(data, this.writeCharsetName);
    }

    @Override
    public ServerHttpExchange write(String data, String charsetName) {
        this.logger.trace("{} sends a text chunk {} with charset {}", new Object[]{this, data, charsetName});
        this.doWrite(Charset.forName(charsetName).encode(data));
        return this;
    }

    @Override
    public ServerHttpExchange write(ByteBuffer byteBuffer) {
        this.logger.trace("{} sends a binary chunk {}", (Object)this, (Object)byteBuffer);
        this.doWrite(byteBuffer);
        return this;
    }

    protected abstract void doWrite(ByteBuffer var1);

    @Override
    public ServerHttpExchange end() {
        this.logger.trace("{} ends the response", (Object)this);
        if (!this.ended) {
            this.ended = true;
            this.doEnd();
            this.finishActions.fire();
        }
        return this;
    }

    protected abstract void doEnd();

    @Override
    public ServerHttpExchange end(String data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange end(String data, String charsetName) {
        return this.write(data, charsetName).end();
    }

    @Override
    public ServerHttpExchange end(ByteBuffer data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange onfinish(Action<Void> action) {
        this.finishActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange onclose(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange onerror(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }
}

