/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.example.spring.webflux5;

import io.cettia.asity.action.Action;
import io.cettia.asity.bridge.spring.webflux5.AsityHandlerFunction;
import io.cettia.asity.bridge.spring.webflux5.AsityWebSocketHandler;
import io.cettia.asity.example.echo.HttpEchoServer;
import io.cettia.asity.example.echo.WebSocketEchoServer;
import io.cettia.asity.http.ServerHttpExchange;
import io.cettia.asity.websocket.ServerWebSocket;
import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@SpringBootApplication
@EnableWebFlux
public class EchoServer {
    @Bean
    public Action<ServerHttpExchange> httpAction() {
        return new HttpEchoServer();
    }

    @Bean
    public Action<ServerWebSocket> wsAction() {
        return new WebSocketEchoServer();
    }

    @Bean
    public RouterFunction<ServerResponse> httpMapping() {
        AsityHandlerFunction asityHandlerFunction = new AsityHandlerFunction().onhttp(this.httpAction());
        return RouterFunctions.route((RequestPredicate)RequestPredicates.path((String)"/echo").and(RequestPredicates.headers(headers -> !"websocket".equalsIgnoreCase(headers.asHttpHeaders().getUpgrade()))), (HandlerFunction)asityHandlerFunction);
    }

    @Bean
    public HandlerMapping wsMapping() {
        AsityWebSocketHandler asityWebSocketHandler = new AsityWebSocketHandler().onwebsocket(this.wsAction());
        LinkedHashMap<String, AsityWebSocketHandler> map = new LinkedHashMap<String, AsityWebSocketHandler>();
        map.put("/echo", asityWebSocketHandler);
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setUrlMap(map);
        return mapping;
    }

    @Bean
    public WebSocketHandlerAdapter webSocketHandlerAdapter() {
        return new WebSocketHandlerAdapter();
    }

    public static void main(String[] args) {
        SpringApplication.run(EchoServer.class, (String[])args);
    }
}

