/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.example.play2;

import akka.actor.ActorSystem;
import akka.stream.Materializer;
import io.cettia.asity.action.Action;
import io.cettia.asity.bridge.play2.AsityHttpAction;
import io.cettia.asity.bridge.play2.AsityWebSocket;
import io.cettia.asity.example.echo.HttpEchoServer;
import io.cettia.asity.example.echo.WebSocketEchoServer;
import io.cettia.asity.http.ServerHttpExchange;
import io.cettia.asity.websocket.ServerWebSocket;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.WebSocket;

public class EchoController
extends Controller {
    private final Action<ServerHttpExchange> httpAction = new HttpEchoServer();
    private final Action<ServerWebSocket> wsAction = new WebSocketEchoServer();
    private final ActorSystem actorSystem;
    private final Materializer materializer;

    @Inject
    public EchoController(ActorSystem actorSystem, Materializer materializer) {
        this.actorSystem = actorSystem;
        this.materializer = materializer;
    }

    @BodyParser.Of(value=BodyParser.Raw.class)
    public CompletionStage<Result> http() {
        Http.Request request = EchoController.request();
        AsityHttpAction action = new AsityHttpAction();
        action.onhttp(this.httpAction);
        return action.apply(request);
    }

    public WebSocket websocket() {
        AsityWebSocket webSocket = new AsityWebSocket(this.actorSystem, this.materializer);
        webSocket.onwebsocket(this.wsAction);
        return webSocket;
    }
}

