/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.vertx3;

import io.cettia.asity.action.Actions;
import io.cettia.asity.websocket.AbstractServerWebSocket;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;

public class VertxServerWebSocket
extends AbstractServerWebSocket {
    private final ServerWebSocket socket;

    public VertxServerWebSocket(ServerWebSocket socket) {
        this.socket = socket;
        socket.closeHandler(arg_0 -> ((Actions)this.closeActions).fire(arg_0)).exceptionHandler(arg_0 -> ((Actions)this.errorActions).fire(arg_0)).frameHandler(frame -> {
            if (frame.isText()) {
                this.textActions.fire((Object)frame.textData());
            } else if (frame.isBinary()) {
                this.binaryActions.fire((Object)frame.binaryData().getByteBuf().nioBuffer());
            }
        });
    }

    public String uri() {
        return this.socket.uri();
    }

    public Set<String> headerNames() {
        return this.socket.headers().names();
    }

    public List<String> headers(String name) {
        return this.socket.headers().getAll(name);
    }

    protected void doClose() {
        this.socket.close();
    }

    protected void doSend(String data) {
        this.socket.writeFinalTextFrame(data);
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.socket.writeFinalBinaryFrame(Buffer.buffer().setBytes(0, byteBuffer));
    }

    public <T> T unwrap(Class<T> clazz) {
        return ServerWebSocket.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.socket) : null;
    }
}

