/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.vertx3;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.http.AbstractServerHttpExchange;
import io.cettia.asity.http.HttpMethod;
import io.cettia.asity.http.HttpStatus;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;

public class VertxServerHttpExchange
extends AbstractServerHttpExchange {
    private final HttpServerRequest request;
    private final HttpServerResponse response;

    public VertxServerHttpExchange(HttpServerRequest request) {
        this.request = request;
        this.response = request.response();
        request.exceptionHandler(arg_0 -> ((Actions)this.errorActions).fire(arg_0));
        this.response.exceptionHandler(arg_0 -> ((Actions)this.errorActions).fire(arg_0)).closeHandler(arg_0 -> ((Actions)this.closeActions).fire(arg_0)).setChunked(true);
    }

    public String uri() {
        return this.request.uri();
    }

    public HttpMethod method() {
        return HttpMethod.valueOf((String)this.request.rawMethod());
    }

    public Set<String> headerNames() {
        return this.request.headers().names();
    }

    public List<String> headers(String name) {
        return this.request.headers().getAll(name);
    }

    protected void doRead(Action<ByteBuffer> chunkAction) {
        this.request.handler(chunk -> chunkAction.on((Object)chunk.getByteBuf().nioBuffer())).endHandler(arg_0 -> ((Actions)this.endActions).fire(arg_0));
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatusCode(status.code()).setStatusMessage(status.reason());
    }

    protected void doSetHeader(String name, String value) {
        this.response.putHeader(name, value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        this.response.write(Buffer.buffer().setBytes(0, byteBuffer));
    }

    protected void doEnd() {
        this.response.end();
    }

    public <T> T unwrap(Class<T> clazz) {
        return HttpServerRequest.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.request) : null;
    }
}

