/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.vertx2;

import io.cettia.asity.action.Actions;
import io.cettia.asity.websocket.AbstractServerWebSocket;
import java.nio.ByteBuffer;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.ws.WebSocketFrameInternal;

public class VertxServerWebSocket
extends AbstractServerWebSocket {
    private final ServerWebSocket socket;

    public VertxServerWebSocket(ServerWebSocket socket) {
        this.socket = socket;
        ((ServerWebSocket)((ServerWebSocket)socket.closeHandler((Handler)new VoidHandler(){

            protected void handle() {
                VertxServerWebSocket.this.closeActions.fire();
            }
        })).exceptionHandler(arg_0 -> ((Actions)this.errorActions).fire(arg_0))).frameHandler(f -> {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)f;
            switch (frame.type()) {
                case TEXT: {
                    this.textActions.fire((Object)frame.textData());
                    break;
                }
                case BINARY: {
                    this.binaryActions.fire((Object)frame.getBinaryData().nioBuffer());
                    break;
                }
            }
        });
    }

    public String uri() {
        return this.socket.uri();
    }

    protected void doClose() {
        this.socket.close();
    }

    protected void doSend(String data) {
        this.socket.writeTextFrame(data);
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.socket.writeBinaryFrame(new Buffer().setBytes(0, byteBuffer));
    }

    public <T> T unwrap(Class<T> clazz) {
        return ServerWebSocket.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.socket) : null;
    }
}

