/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.spring.webmvc4;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.action.ConcurrentActions;
import io.cettia.asity.bridge.spring.webmvc4.SpringWebMvcServerWebSocket;
import io.cettia.asity.websocket.ServerWebSocket;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public class AsityWebSocketHandler
extends AbstractWebSocketHandler {
    private Actions<ServerWebSocket> wsActions = new ConcurrentActions();
    private Map<String, SpringWebMvcServerWebSocket> sessions = new ConcurrentHashMap<String, SpringWebMvcServerWebSocket>();

    public void afterConnectionEstablished(WebSocketSession session) {
        SpringWebMvcServerWebSocket ws = new SpringWebMvcServerWebSocket(session);
        this.sessions.put(session.getId(), ws);
        this.wsActions.fire((Object)ws);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        SpringWebMvcServerWebSocket ws = this.sessions.remove(session.getId());
        ws.onClose();
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) {
        SpringWebMvcServerWebSocket ws = this.sessions.get(session.getId());
        ws.onError(exception);
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) {
        SpringWebMvcServerWebSocket ws = this.sessions.get(session.getId());
        ws.onTextMessage((String)message.getPayload());
    }

    protected void handleBinaryMessage(WebSocketSession session, BinaryMessage message) {
        SpringWebMvcServerWebSocket ws = this.sessions.get(session.getId());
        ws.onBinaryMessage((ByteBuffer)message.getPayload());
    }

    public AsityWebSocketHandler onwebsocket(Action<ServerWebSocket> action) {
        this.wsActions.add(action);
        return this;
    }
}

