/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.spring.webmvc4;

import io.cettia.asity.websocket.AbstractServerWebSocket;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class SpringWebMvcServerWebSocket
extends AbstractServerWebSocket {
    private final WebSocketSession session;

    public SpringWebMvcServerWebSocket(WebSocketSession session) {
        this.session = session;
    }

    void onClose() {
        this.closeActions.fire();
    }

    void onError(Throwable e) {
        this.errorActions.fire((Object)e);
    }

    void onTextMessage(String textMessage) {
        this.textActions.fire((Object)textMessage);
    }

    void onBinaryMessage(ByteBuffer binaryMessage) {
        this.binaryActions.fire((Object)binaryMessage);
    }

    public String uri() {
        URI uri = this.session.getUri();
        return uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
    }

    public Set<String> headerNames() {
        return this.session.getHandshakeHeaders().keySet();
    }

    public List<String> headers(String name) {
        return this.session.getHandshakeHeaders().get((Object)name);
    }

    protected void doSend(ByteBuffer byteBuffer) {
        try {
            this.session.sendMessage((WebSocketMessage)new BinaryMessage(byteBuffer));
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doSend(String data) {
        try {
            this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)data));
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doClose() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        return WebSocketSession.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.session) : null;
    }
}

